/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import net.minecraft.launcher.authentication.OldAuthentication;

public enum MinecraftProcessArguments {
    LEGACY("%s %s", false),
    USERNAME_SESSION("--username %s --session %s", false),
    USERNAME_SESSION_UUID("--username %s --session %s --uuid %s", true);

    private final String format;
    private final boolean useUuid;

    private MinecraftProcessArguments(String format, boolean useUuid) {
        this.format = format;
        this.useUuid = useUuid;
    }

    public String formatAuthResponse(OldAuthentication.Response response) {
        if (this.useUuid) {
            return String.format(this.format, response.getName(), response.getSessionId(), response.getUUID());
        }
        return String.format(this.format, response.getName(), response.getSessionId());
    }
}

