/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.sidebar.SidebarGridForm;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.updater.events.RefreshedVersionsListener;
import net.minecraft.launcher.versions.Version;

public class VersionSelection
extends SidebarGridForm
implements ItemListener,
RefreshedVersionsListener {
    private final JComboBox versionList = new JComboBox();
    private final JLabel infoLabel = new JLabel();
    private final Launcher launcher;

    public VersionSelection(Launcher launcher) {
        super("Version Selection");
        this.launcher = launcher;
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        this.versionList.setRenderer(new VersionListRenderer());
        this.versionList.addItemListener(this);
        this.versionList.addItem("Loading versions...");
        this.createInterface();
        launcher.getVersionManager().addRefreshedVersionsListener(this);
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        this.add(new JLabel("Version:", 4), constraints, 0, 0, 0, 1);
        this.add(this.versionList, constraints, 1, 0, 1, 1);
        this.add(new JLabel("Status:", 4), constraints, 0, 1, 0, 1);
        this.add(this.infoLabel, constraints, 1, 1, 1, 1);
    }

    public JComboBox getVersionList() {
        return this.versionList;
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        List<VersionSyncInfo> versions = manager.getVersions();
        Collections.sort(versions, new Comparator<VersionSyncInfo>(){

            @Override
            public int compare(VersionSyncInfo a, VersionSyncInfo b) {
                Version aVer = a.getLatestVersion();
                Version bVer = b.getLatestVersion();
                if (aVer.getReleaseTime() != null && bVer.getReleaseTime() != null) {
                    return bVer.getReleaseTime().compareTo(aVer.getReleaseTime());
                }
                return bVer.getUpdatedTime().compareTo(aVer.getUpdatedTime());
            }
        });
        this.populateVersions(versions);
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    public VersionSyncInfo getSelectedVersion() {
        if (this.versionList.getSelectedItem() instanceof VersionSyncInfo) {
            return (VersionSyncInfo)this.versionList.getSelectedItem();
        }
        return null;
    }

    public void populateVersions(List<VersionSyncInfo> versions) {
        VersionSyncInfo previous = this.getSelectedVersion();
        this.versionList.removeAllItems();
        VersionSyncInfo selected = null;
        for (VersionSyncInfo version : versions) {
            if (previous != null && version.getLatestVersion().getId().equals(previous.getLatestVersion().getId())) {
                selected = version;
            }
            this.versionList.addItem(version);
        }
        if (selected == null && !versions.isEmpty()) {
            selected = versions.get(0);
        }
        this.versionList.setSelectedItem(selected);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == null) {
            this.infoLabel.setText("");
        } else if (e.getItem() instanceof VersionSyncInfo) {
            VersionSyncInfo syncInfo = (VersionSyncInfo)e.getItem();
            if (syncInfo.isInstalled()) {
                if (syncInfo.isUpToDate()) {
                    this.infoLabel.setText("Up to date.");
                } else {
                    this.infoLabel.setText("<html><b>Update available!</b></html>");
                }
            } else {
                this.infoLabel.setText("<html><b>Will be installed.</b></html>");
            }
        }
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    private static class VersionListRenderer
    extends BasicComboBoxRenderer {
        private final Font uninstalledFont = new Font(this.getFont().getName(), 2, this.getFont().getSize());
        private final Font updatableFont = new Font(this.getFont().getName(), 1, this.getFont().getSize());

        private VersionListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VersionSyncInfo) {
                VersionSyncInfo syncInfo = (VersionSyncInfo)value;
                Version version = syncInfo.getLatestVersion();
                super.getListCellRendererComponent((JList<?>)list, String.format("%s %s", version.getType().getName(), version.getId()), index, isSelected, cellHasFocus);
                if (syncInfo.isInstalled()) {
                    if (!syncInfo.isUpToDate()) {
                        this.setFont(this.updatableFont);
                    }
                } else {
                    this.setFont(this.uninstalledFont);
                }
            } else {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            return this;
        }
    }
}

