/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar.login;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.OldAuthentication;
import net.minecraft.launcher.ui.popups.ErrorMessagePopup;
import net.minecraft.launcher.ui.sidebar.login.BaseLogInForm;
import net.minecraft.launcher.ui.sidebar.login.LoginContainerForm;

public class NotLoggedInForm
extends BaseLogInForm {
    private final JTextField usernameField = new JTextField(20);
    private final JPasswordField passwordField = new JPasswordField(20);
    private final JButton playButton = new JButton("Play");
    private final JButton registerButton = new JButton("Register");
    private final JCheckBox rememberMeCheckbox = new JCheckBox("Log me in automatically");

    public NotLoggedInForm(LoginContainerForm container) {
        super(container, "Log In");
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        this.createInterface();
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        constraints.fill = 2;
        JLabel usernameLabel = new JLabel("Username:", 2);
        usernameLabel.setLabelFor(this.usernameField);
        this.add(usernameLabel, constraints, 0, 0, 0, 1);
        this.add(this.usernameField, constraints, 1, 0, 1, 0);
        JLabel passwordLabel = new JLabel("Password:", 2);
        passwordLabel.setLabelFor(this.passwordField);
        this.add(passwordLabel, constraints, 0, 1, 0, 1);
        this.add(this.passwordField, constraints, 1, 1, 1, 0);
        this.add(this.rememberMeCheckbox, constraints, 0, 2, 0, 2).setEnabled(false);
        this.playButton.addActionListener(this);
        this.registerButton.addActionListener(this);
        this.registerButton.setDefaultCapable(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.registerButton);
        buttonPanel.add(this.playButton);
        this.playButton.setFont(new Font(this.playButton.getFont().getName(), 1, this.playButton.getFont().getSize()));
        this.add(buttonPanel, constraints, 0, 3, 0, 0);
    }

    public JCheckBox getRememberMeCheckbox() {
        return this.rememberMeCheckbox;
    }

    public JTextField getUsernameField() {
        return this.usernameField;
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    public JButton getPlayButton() {
        return this.playButton;
    }

    public JButton getRegisterButton() {
        return this.registerButton;
    }

    @Override
    public void checkLoginState() {
        boolean canLogIn = true;
        if (this.getLauncher().getGameLauncher().isWorking()) {
            canLogIn = false;
        }
        if (this.getLauncher().getVersionManager().getVersions().size() <= 0) {
            canLogIn = false;
        }
        if (this.getLauncher().getAuthentication().isAuthenticating()) {
            canLogIn = false;
        }
        this.playButton.setEnabled(canLogIn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OldAuthentication authentication = this.getLauncher().getAuthentication();
        if (e.getSource() == this.playButton) {
            OldAuthentication.Response response = authentication.getLastSuccessfulResponse();
            if (response != null) {
                this.getLauncher().getGameLauncher().playGame();
            } else {
                this.tryLogIn(true, true);
            }
        } else {
            try {
                OperatingSystem.openLink(new URI("https://account.mojang.com/register"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public void tryLogIn(final boolean launchOnSuccess, final boolean verbose) {
        final OldAuthentication authentication = this.getLauncher().getAuthentication();
        authentication.setAuthenticating(true);
        this.getLoginContainer().checkLoginState();
        this.getLauncher().getVersionManager().getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.getInstance().println("Trying to log in...");
                    OldAuthentication.Response response = authentication.login(NotLoggedInForm.this.usernameField.getText(), new String(NotLoggedInForm.this.passwordField.getPassword()));
                    if (response.getErrorMessage() != null) {
                        NotLoggedInForm.this.loginFailed(response.getErrorMessage(), verbose);
                    } else if (response.getSessionId() == null) {
                        NotLoggedInForm.this.loginFailed("Could not log in: SessionID was null?", verbose);
                    } else if (response.getName() == null) {
                        NotLoggedInForm.this.loginFailed("Could not log in: Name was null?", verbose);
                    } else if (response.getUUID() == null) {
                        NotLoggedInForm.this.loginFailed("Could not log in: UUID was null?", verbose);
                    } else {
                        NotLoggedInForm.this.getLauncher().println("Logged in successfully");
                        NotLoggedInForm.this.getLauncher().getAuthentication().setAuthenticating(false);
                        if (launchOnSuccess) {
                            NotLoggedInForm.this.getLauncher().getGameLauncher().playGame();
                        } else {
                            NotLoggedInForm.this.getLoginContainer().checkLoginState();
                        }
                    }
                }
                catch (Throwable ex) {
                    NotLoggedInForm.this.loginFailed("Could not log in: " + ex.getMessage(), verbose);
                }
            }
        });
    }

    private void loginFailed(String error, boolean verbose) {
        Launcher.getInstance().println(error);
        if (verbose) {
            ErrorMessagePopup.show(this.getLauncher().getFrame(), error);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotLoggedInForm.this.getLauncher().getAuthentication().setAuthenticating(false);
                NotLoggedInForm.this.getLoginContainer().checkLoginState();
            }
        });
    }
}

