/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.profile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.updater.DateTypeAdapter;
import net.minecraft.launcher.updater.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.io.FileUtils;

public class ProfileManager {
    public static final String DEFAULT_PROFILE_NAME = "(Default)";
    private final Launcher launcher;
    private final Gson gson;
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final File profileFile;
    private Profile selectedProfile;

    public ProfileManager(Launcher launcher) {
        this.launcher = launcher;
        this.profileFile = new File(launcher.getWorkingDirectory(), "launcher_profiles.json");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public void saveProfiles() throws IOException {
        RawProfileList rawProfileList = new RawProfileList();
        rawProfileList.profiles = this.profiles;
        rawProfileList.selectedProfile = this.getSelectedProfile().getName();
        FileUtils.writeStringToFile(this.profileFile, this.gson.toJson(rawProfileList));
    }

    public boolean loadProfiles() throws IOException {
        this.profiles.clear();
        this.selectedProfile = null;
        if (this.profileFile.isFile()) {
            RawProfileList rawProfileList = this.gson.fromJson(FileUtils.readFileToString(this.profileFile), RawProfileList.class);
            this.profiles.putAll(rawProfileList.profiles);
            this.selectedProfile = this.profiles.get(rawProfileList.selectedProfile);
            return true;
        }
        return false;
    }

    public Profile getSelectedProfile() {
        if (this.selectedProfile == null) {
            if (this.profiles.get(DEFAULT_PROFILE_NAME) != null) {
                this.selectedProfile = this.profiles.get(DEFAULT_PROFILE_NAME);
            } else if (this.profiles.size() > 0) {
                this.selectedProfile = this.profiles.values().iterator().next();
            } else {
                this.selectedProfile = new Profile(DEFAULT_PROFILE_NAME);
                this.profiles.put(DEFAULT_PROFILE_NAME, this.selectedProfile);
            }
        }
        return this.selectedProfile;
    }

    public Map<String, Profile> getProfiles() {
        return this.profiles;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    private static class RawProfileList {
        public Map<String, Profile> profiles = new HashMap<String, Profile>();
        public String selectedProfile;

        private RawProfileList() {
        }
    }
}

