/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar.login;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.minecraft.launcher.authentication.OldAuthentication;
import net.minecraft.launcher.ui.sidebar.login.BaseLogInForm;
import net.minecraft.launcher.ui.sidebar.login.LoginContainerForm;

public class LoggedInForm
extends BaseLogInForm {
    private final JButton playButton = new JButton("Play");
    private final JButton logOutButton = new JButton("Log Out");
    private final JLabel welcomeText = new JLabel("<html>OH NO PANIC! :(</html>");

    public LoggedInForm(LoginContainerForm container) {
        super(container, "Play Game");
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        this.createInterface();
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        constraints.fill = 2;
        this.add(this.welcomeText, constraints, 0, 0, 0, 0);
        this.playButton.addActionListener(this);
        this.logOutButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.logOutButton);
        buttonPanel.add(this.playButton);
        this.playButton.setFont(new Font(this.playButton.getFont().getName(), 1, this.playButton.getFont().getSize()));
        this.add(buttonPanel, constraints, 0, 3, 0, 0);
    }

    @Override
    public void checkLoginState() {
        boolean canPlay = true;
        boolean canLogOut = true;
        OldAuthentication authentication = this.getLauncher().getAuthentication();
        OldAuthentication.Response response = authentication.getLastSuccessfulResponse();
        if (this.getLauncher().getGameLauncher().isWorking()) {
            canPlay = false;
            canLogOut = false;
        }
        if (this.getLauncher().getVersionManager().getVersions().size() <= 0) {
            canPlay = false;
        }
        if (authentication.isAuthenticating()) {
            canPlay = false;
            canLogOut = false;
        }
        if (response != null) {
            this.welcomeText.setText("<html>Welcome, <b>" + authentication.getLastSuccessfulResponse().getPlayerName() + "</b>!</html>");
        } else {
            this.welcomeText.setText("<html>Welcome, guest!</html>");
        }
        this.logOutButton.setEnabled(canLogOut);
        this.playButton.setEnabled(canPlay);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.playButton) {
            this.getLauncher().getVersionManager().getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    LoggedInForm.this.getLauncher().getGameLauncher().playGame();
                }
            });
        } else if (e.getSource() == this.logOutButton) {
            this.getLauncher().getAuthentication().clearLastSuccessfulResponse();
            this.getLoginContainer().checkLoginState();
        }
    }
}

