/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar.login;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.sidebar.login.BaseLogInForm;
import net.minecraft.launcher.ui.sidebar.login.LoginContainerForm;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NotLoggedInForm
extends BaseLogInForm {
    private final JTextField usernameField = new JTextField(20);
    private final JPasswordField passwordField = new JPasswordField(20);
    private final JButton playButton = new JButton("Play");
    private final JButton registerButton = new JButton("Register");
    private final JCheckBox rememberMeCheckbox = new JCheckBox("Log me in automatically");

    public NotLoggedInForm(LoginContainerForm container) {
        super(container, "Log In");
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        this.createInterface();
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        constraints.fill = 2;
        JLabel usernameLabel = new JLabel("Username:", 2);
        usernameLabel.setLabelFor(this.usernameField);
        this.add(usernameLabel, constraints, 0, 0, 0, 1);
        this.add(this.usernameField, constraints, 1, 0, 1, 0);
        JLabel passwordLabel = new JLabel("Password:", 2);
        passwordLabel.setLabelFor(this.passwordField);
        this.add(passwordLabel, constraints, 0, 1, 0, 1);
        this.add(this.passwordField, constraints, 1, 1, 1, 0);
        this.add(this.rememberMeCheckbox, constraints, 0, 2, 0, 2).setEnabled(false);
        this.playButton.addActionListener(this);
        this.usernameField.addActionListener(this);
        this.passwordField.addActionListener(this);
        this.registerButton.addActionListener(this);
        this.registerButton.setDefaultCapable(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.registerButton);
        buttonPanel.add(this.playButton);
        this.playButton.setFont(new Font(this.playButton.getFont().getName(), 1, this.playButton.getFont().getSize()));
        this.add(buttonPanel, constraints, 0, 3, 0, 0);
    }

    public JCheckBox getRememberMeCheckbox() {
        return this.rememberMeCheckbox;
    }

    public JTextField getUsernameField() {
        return this.usernameField;
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    public JButton getPlayButton() {
        return this.playButton;
    }

    public JButton getRegisterButton() {
        return this.registerButton;
    }

    @Override
    public void checkLoginState() {
        boolean canLogIn = true;
        if (this.getLauncher().getGameLauncher().isWorking()) {
            canLogIn = false;
        }
        if (this.getLauncher().getVersionManager().getVersions().size() <= 0) {
            canLogIn = false;
        }
        this.playButton.setEnabled(canLogIn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AuthenticationService authentication = this.getLauncher().getProfileManager().getSelectedProfile().getAuthentication();
        if (e.getSource() == this.playButton || e.getSource() == this.usernameField || e.getSource() == this.passwordField) {
            if (authentication.isLoggedIn() && (ArrayUtils.isEmpty(authentication.getAvailableProfiles()) || authentication.getSelectedProfile() != null)) {
                this.getLauncher().getGameLauncher().playGame();
            } else {
                this.tryLogIn(true, true);
            }
        } else {
            try {
                OperatingSystem.openLink(new URI("https://account.mojang.com/register"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onProfilesRefreshed(ProfileManager manager) {
        Profile profile = manager.getSelectedProfile();
        AuthenticationService authentication = profile.getAuthentication();
        if (authentication.isLoggedIn() && authentication.canPlayOnline()) {
            this.checkLoginState();
        } else if (!StringUtils.isBlank(authentication.getUsername())) {
            this.getUsernameField().setText(authentication.getUsername());
            String password = authentication.guessPasswordFromSillyOldFormat(new File(this.getLauncher().getWorkingDirectory(), "lastlogin"));
            if (!StringUtils.isBlank(password)) {
                this.getLauncher().println("Going to log in with legacy stored username & password...");
                this.getPasswordField().setText(password);
            }
            authentication.setPassword(String.valueOf(this.passwordField.getPassword()));
            if (authentication.canLogIn()) {
                this.tryLogIn(false, false);
            }
        } else {
            this.getUsernameField().setText("");
            this.getPasswordField().setText("");
        }
    }

    public void tryLogIn(final boolean launchOnSuccess, final boolean verbose) {
        final Profile profile = this.getLauncher().getProfileManager().getSelectedProfile();
        final AuthenticationService authentication = profile.getAuthentication();
        this.getLoginContainer().checkLoginState();
        this.getLauncher().getVersionManager().getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                String username = NotLoggedInForm.this.usernameField.getText();
                try {
                    Launcher.getInstance().println("Trying to log in...");
                    authentication.setUsername(username);
                    authentication.setPassword(String.valueOf(NotLoggedInForm.this.getPasswordField().getPassword()));
                    authentication.logIn();
                    if (!NotLoggedInForm.this.getLauncher().getProfileManager().getSelectedProfile().equals(profile)) {
                        NotLoggedInForm.this.getLauncher().println("Profile changed during authentication, ignoring response.");
                        NotLoggedInForm.this.getLoginContainer().checkLoginState();
                        return;
                    }
                    NotLoggedInForm.this.getLauncher().println("Logged in successfully");
                    NotLoggedInForm.this.saveAuthenticationDetails(profile);
                    if (launchOnSuccess) {
                        NotLoggedInForm.this.getLauncher().getGameLauncher().playGame();
                    } else {
                        NotLoggedInForm.this.getLoginContainer().checkLoginState();
                    }
                }
                catch (Throwable ex) {
                    if (!NotLoggedInForm.this.getLauncher().getProfileManager().getSelectedProfile().equals(profile)) {
                        NotLoggedInForm.this.getLauncher().println("Profile changed during authentication, ignoring response (which was an error anyway).");
                        NotLoggedInForm.this.getLoginContainer().checkLoginState();
                        return;
                    }
                    if (authentication.isLoggedIn()) {
                        NotLoggedInForm.this.getLauncher().println("Couldn't go online", ex);
                        if (authentication.getSelectedProfile() != null) {
                            Launcher.getInstance().println("Going to play offline as '" + authentication.getSelectedProfile().getName() + "'...");
                        } else {
                            Launcher.getInstance().println("Going to play offline demo...");
                        }
                        NotLoggedInForm.this.getLoginContainer().checkLoginState();
                    }
                    NotLoggedInForm.this.loginFailed(ex.getMessage(), verbose, authentication.getUsername().contains("@"));
                }
            }
        });
    }

    private void saveAuthenticationDetails(Profile profile) {
        try {
            this.getLauncher().getProfileManager().saveProfiles();
        }
        catch (IOException e) {
            this.getLauncher().println("Couldn't save authentication details to profile", e);
        }
    }

    private void loginFailed(final String error, final boolean verbose, final boolean mojangAccount) {
        Launcher.getInstance().println("Could not log in: " + error);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (verbose) {
                    Object[] buttons;
                    String url = mojangAccount ? "https://account.mojang.com/resetpassword/request" : "https://minecraft.net/resetpassword";
                    String errorMessage = "";
                    if (StringUtils.containsIgnoreCase(error, "migrated")) {
                        errorMessage = errorMessage + "Your account has been migrated to a Mojang account.";
                        errorMessage = errorMessage + "\nTo log in, please use your email address and not your minecraft name.";
                        buttons = new String[]{"Need help?", "Okay"};
                        url = "http://help.mojang.com/customer/portal/articles/1205055-minecraft-launcher-error---migrated-account";
                    } else {
                        errorMessage = errorMessage + "Sorry, but your username or password is incorrect!";
                        errorMessage = errorMessage + "\nPlease try again, and check your Caps Lock key is not turned on.";
                        errorMessage = errorMessage + "\nIf you're having trouble, try the 'Forgot Password' button or visit help.mojang.com";
                        buttons = new String[]{"Forgot Password", "Okay"};
                    }
                    int result = JOptionPane.showOptionDialog(NotLoggedInForm.this.getLauncher().getFrame(), errorMessage, "Could not log in", 0, 0, null, buttons, buttons[0]);
                    if (result == 0) {
                        try {
                            OperatingSystem.openLink(new URI(url));
                        }
                        catch (URISyntaxException e) {
                            NotLoggedInForm.this.getLauncher().println("Couldn't open help link. Please visit " + url + " manually.", e);
                        }
                    }
                }
                NotLoggedInForm.this.getLoginContainer().checkLoginState();
            }
        });
    }
}

