/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.updater.ExceptionalThreadPoolExecutor;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.updater.download.DownloadJob;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionManager {
    private final VersionList localVersionList;
    private final VersionList remoteVersionList;
    private final ThreadPoolExecutor executorService = new ExceptionalThreadPoolExecutor(8);
    private final List<RefreshedVersionsListener> refreshedVersionsListeners = Collections.synchronizedList(new ArrayList());
    private final Object refreshLock = new Object();
    private boolean isRefreshing;

    public VersionManager(VersionList localVersionList, VersionList remoteVersionList) {
        this.localVersionList = localVersionList;
        this.remoteVersionList = remoteVersionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshVersions() throws IOException {
        Object object = this.refreshLock;
        synchronized (object) {
            this.isRefreshing = true;
        }
        try {
            this.localVersionList.refreshVersions();
            this.remoteVersionList.refreshVersions();
        }
        catch (IOException ex) {
            Object object2 = this.refreshLock;
            synchronized (object2) {
                this.isRefreshing = false;
            }
            throw ex;
        }
        if (this.localVersionList instanceof LocalVersionList) {
            for (Version version : this.remoteVersionList.getVersions()) {
                String id = version.getId();
                if (this.localVersionList.getVersion(id) == null) continue;
                this.localVersionList.removeVersion(id);
                this.localVersionList.addVersion(this.remoteVersionList.getCompleteVersion(id));
                try {
                    ((LocalVersionList)this.localVersionList).saveVersion(this.localVersionList.getCompleteVersion(id));
                }
                catch (IOException ex) {
                    Object object3 = this.refreshLock;
                    synchronized (object3) {
                        this.isRefreshing = false;
                    }
                    throw ex;
                }
            }
        }
        Iterator<Version> i$ = this.refreshLock;
        synchronized (i$) {
            this.isRefreshing = false;
        }
        final ArrayList<RefreshedVersionsListener> listeners = new ArrayList<RefreshedVersionsListener>(this.refreshedVersionsListeners);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RefreshedVersionsListener listener = (RefreshedVersionsListener)iterator.next();
            if (listener.shouldReceiveEventsInUIThread()) continue;
            listener.onVersionsRefreshed(this);
            iterator.remove();
        }
        if (!listeners.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (RefreshedVersionsListener listener : listeners) {
                        listener.onVersionsRefreshed(VersionManager.this);
                    }
                }
            });
        }
    }

    public List<VersionSyncInfo> getVersions() {
        return this.getVersions(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VersionSyncInfo> getVersions(VersionFilter filter) {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.isRefreshing) {
                return new ArrayList<VersionSyncInfo>();
            }
        }
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        HashMap<String, VersionSyncInfo> lookup = new HashMap<String, VersionSyncInfo>();
        EnumMap<ReleaseType, Integer> counts = new EnumMap<ReleaseType, Integer>(ReleaseType.class);
        for (ReleaseType type : ReleaseType.values()) {
            counts.put(type, 0);
        }
        for (Version version : this.localVersionList.getVersions()) {
            if (version.getType() == null || version.getUpdatedTime() == null) continue;
            VersionSyncInfo syncInfo = this.getVersionSyncInfo(version, this.remoteVersionList.getVersion(version.getId()));
            lookup.put(version.getId(), syncInfo);
            result.add(syncInfo);
        }
        for (Version version : this.remoteVersionList.getVersions()) {
            if (version.getType() == null || version.getUpdatedTime() == null || lookup.containsKey(version.getId()) || filter != null && (!filter.getTypes().contains((Object)version.getType()) || (Integer)counts.get((Object)version.getType()) >= filter.getMaxCount())) continue;
            VersionSyncInfo syncInfo = this.getVersionSyncInfo(this.localVersionList.getVersion(version.getId()), version);
            lookup.put(version.getId(), syncInfo);
            result.add(syncInfo);
            if (filter == null) continue;
            counts.put(version.getType(), (Integer)counts.get((Object)version.getType()) + 1);
        }
        Collections.sort(result, new Comparator<VersionSyncInfo>(){

            @Override
            public int compare(VersionSyncInfo a, VersionSyncInfo b) {
                Version aVer = a.getLatestVersion();
                Version bVer = b.getLatestVersion();
                if (aVer.getReleaseTime() != null && bVer.getReleaseTime() != null) {
                    return bVer.getReleaseTime().compareTo(aVer.getReleaseTime());
                }
                return bVer.getUpdatedTime().compareTo(aVer.getUpdatedTime());
            }
        });
        return result;
    }

    public VersionSyncInfo getVersionSyncInfo(Version version) {
        return this.getVersionSyncInfo(version.getId());
    }

    public VersionSyncInfo getVersionSyncInfo(String name) {
        return this.getVersionSyncInfo(this.localVersionList.getVersion(name), this.remoteVersionList.getVersion(name));
    }

    public VersionSyncInfo getVersionSyncInfo(Version localVersion, Version remoteVersion) {
        boolean installed;
        boolean upToDate = installed = localVersion != null;
        if (installed && remoteVersion != null) {
            boolean bl = upToDate = !remoteVersion.getUpdatedTime().after(localVersion.getUpdatedTime());
        }
        if (localVersion instanceof CompleteVersion) {
            upToDate &= this.localVersionList.hasAllFiles((CompleteVersion)localVersion, OperatingSystem.getCurrentPlatform());
        }
        return new VersionSyncInfo(localVersion, remoteVersion, installed, upToDate);
    }

    public List<VersionSyncInfo> getInstalledVersions() {
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        for (Version version : this.localVersionList.getVersions()) {
            if (version.getType() == null || version.getUpdatedTime() == null) continue;
            VersionSyncInfo syncInfo = this.getVersionSyncInfo(version, this.remoteVersionList.getVersion(version.getId()));
            result.add(syncInfo);
        }
        return result;
    }

    public VersionList getRemoteVersionList() {
        return this.remoteVersionList;
    }

    public VersionList getLocalVersionList() {
        return this.localVersionList;
    }

    public CompleteVersion getLatestCompleteVersion(VersionSyncInfo syncInfo) throws IOException {
        if (syncInfo.getLatestSource() == VersionSyncInfo.VersionSource.REMOTE) {
            CompleteVersion result = null;
            IOException exception = null;
            try {
                result = this.remoteVersionList.getCompleteVersion(syncInfo.getLatestVersion());
            }
            catch (IOException e) {
                exception = e;
                try {
                    result = this.localVersionList.getCompleteVersion(syncInfo.getLatestVersion());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (result != null) {
                return result;
            }
            throw exception;
        }
        return this.localVersionList.getCompleteVersion(syncInfo.getLatestVersion());
    }

    public DownloadJob downloadVersion(VersionSyncInfo syncInfo, DownloadJob job) throws IOException {
        if (!(this.localVersionList instanceof LocalVersionList)) {
            throw new IllegalArgumentException("Cannot download if local repo isn't a LocalVersionList");
        }
        if (!(this.remoteVersionList instanceof RemoteVersionList)) {
            throw new IllegalArgumentException("Cannot download if local repo isn't a RemoteVersionList");
        }
        CompleteVersion version = this.getLatestCompleteVersion(syncInfo);
        File baseDirectory = ((LocalVersionList)this.localVersionList).getBaseDirectory();
        Proxy proxy = ((RemoteVersionList)this.remoteVersionList).getProxy();
        if (!syncInfo.isInstalled() || !syncInfo.isUpToDate()) {
            job.addDownloadables(version.getRequiredDownloadables(OperatingSystem.getCurrentPlatform(), proxy, baseDirectory, false));
        }
        String jarFile = "versions/" + version.getId() + "/" + version.getId() + ".jar";
        job.addDownloadables(new Downloadable(proxy, new URL("https://s3.amazonaws.com/Minecraft.Download/" + jarFile), new File(baseDirectory, jarFile), false));
        return job;
    }

    public DownloadJob downloadResources(DownloadJob job) throws IOException {
        File baseDirectory = ((LocalVersionList)this.localVersionList).getBaseDirectory();
        job.addDownloadables(this.getResourceFiles(((RemoteVersionList)this.remoteVersionList).getProxy(), baseDirectory));
        return job;
    }

    private Set<Downloadable> getResourceFiles(Proxy proxy, File baseDirectory) {
        HashSet<Downloadable> result = new HashSet<Downloadable>();
        try {
            URL resourceUrl = new URL("https://s3.amazonaws.com/Minecraft.Resources/");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(resourceUrl.openStream());
            NodeList nodeLst = doc.getElementsByTagName("Contents");
            long start = System.nanoTime();
            for (int i = 0; i < nodeLst.getLength(); ++i) {
                Node node = nodeLst.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String key = element.getElementsByTagName("Key").item(0).getChildNodes().item(0).getNodeValue();
                String etag = element.getElementsByTagName("ETag") != null ? element.getElementsByTagName("ETag").item(0).getChildNodes().item(0).getNodeValue() : "-";
                long size = Long.parseLong(element.getElementsByTagName("Size").item(0).getChildNodes().item(0).getNodeValue());
                if (size <= 0L) continue;
                File file = new File(baseDirectory, "assets/" + key);
                if (etag.length() > 1) {
                    String localMd5;
                    etag = Downloadable.getEtag(etag);
                    if (file.isFile() && file.length() == size && (localMd5 = Downloadable.getMD5(file)).equals(etag)) continue;
                }
                result.add(new Downloadable(proxy, new URL("https://s3.amazonaws.com/Minecraft.Resources/" + key), file, false));
            }
            long end = System.nanoTime();
            long delta = end - start;
            Launcher.getInstance().println("Delta time to compare resources: " + delta / 1000000L + " ms ");
        }
        catch (Exception ex) {
            Launcher.getInstance().println("Couldn't download resources", ex);
        }
        return result;
    }

    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    public void addRefreshedVersionsListener(RefreshedVersionsListener listener) {
        this.refreshedVersionsListeners.add(listener);
    }

    public void removeRefreshedVersionsListener(RefreshedVersionsListener listener) {
        this.refreshedVersionsListeners.remove(listener);
    }
}

