/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar.login;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.sidebar.login.BaseLogInForm;
import net.minecraft.launcher.ui.sidebar.login.LoginContainerForm;

public class LoggedInForm
extends BaseLogInForm {
    private final JButton playButton = new JButton("Play");
    private final JButton logOutButton = new JButton("Log Out");
    private final JLabel welcomeText = new JLabel("<html>OH NO PANIC! :(</html>");
    private AuthenticationService previousAuthentication = null;

    public LoggedInForm(LoginContainerForm container) {
        super(container, "Play Game");
        this.createInterface();
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        constraints.fill = 2;
        this.add(this.welcomeText, constraints, 0, 0, 0, 0);
        this.playButton.addActionListener(this);
        this.logOutButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.logOutButton);
        buttonPanel.add(this.playButton);
        this.playButton.setFont(new Font(this.playButton.getFont().getName(), 1, this.playButton.getFont().getSize()));
        this.add(buttonPanel, constraints, 0, 3, 0, 0);
    }

    @Override
    public void checkLoginState() {
        boolean canPlay = true;
        boolean canLogOut = true;
        Profile profile = this.getLauncher().getProfileManager().getSelectedProfile();
        AuthenticationService authentication = profile.getAuthentication();
        if (this.getLauncher().getGameLauncher().isWorking()) {
            canPlay = false;
            canLogOut = false;
        }
        if (this.getLauncher().getVersionManager().getVersions(profile.getVersionFilter()).size() <= 0) {
            canPlay = false;
        }
        this.welcomeText.setText("<html>Welcome, guest!</html>");
        if (authentication.isLoggedIn()) {
            if (authentication.getSelectedProfile() == null) {
                this.playButton.setText("Play Demo");
            } else {
                this.welcomeText.setText("<html>Welcome, <b>" + authentication.getSelectedProfile().getName() + "</b>!</html>");
                if (authentication.canPlayOnline()) {
                    this.playButton.setText("Play");
                } else {
                    this.playButton.setText("Play Offline");
                }
            }
        }
        this.logOutButton.setEnabled(canLogOut);
        this.playButton.setEnabled(canPlay);
        this.previousAuthentication = authentication;
    }

    @Override
    public void onProfilesRefreshed(ProfileManager manager) {
        Profile profile = manager.getSelectedProfile();
        if (profile.getAuthentication() != this.previousAuthentication) {
            this.getLoginContainer().checkLoginState();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.playButton) {
            this.getLauncher().getVersionManager().getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    LoggedInForm.this.getLauncher().getGameLauncher().playGame();
                }
            });
        } else if (e.getSource() == this.logOutButton) {
            this.getLauncher().getProfileManager().getSelectedProfile().getAuthentication().logOut();
            this.getLoginContainer().checkLoginState();
        }
    }
}

