/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication.yggdrasil;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.LauncherConstants;
import net.minecraft.launcher.authentication.BaseAuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.exceptions.InvalidCredentialsException;
import net.minecraft.launcher.authentication.yggdrasil.Agent;
import net.minecraft.launcher.authentication.yggdrasil.AuthenticationRequest;
import net.minecraft.launcher.authentication.yggdrasil.AuthenticationResponse;
import net.minecraft.launcher.authentication.yggdrasil.InvalidateRequest;
import net.minecraft.launcher.authentication.yggdrasil.RefreshRequest;
import net.minecraft.launcher.authentication.yggdrasil.RefreshResponse;
import net.minecraft.launcher.authentication.yggdrasil.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class YggdrasilAuthenticationService
extends BaseAuthenticationService {
    private static final String BASE_URL = "https://authserver.mojang.com/";
    private static final URL ROUTE_AUTHENTICATE = LauncherConstants.constantURL("https://authserver.mojang.com/authenticate");
    private static final URL ROUTE_REFRESH = LauncherConstants.constantURL("https://authserver.mojang.com/refresh");
    private static final URL ROUTE_VALIDATE = LauncherConstants.constantURL("https://authserver.mojang.com/validate");
    private static final URL ROUTE_INVALIDATE = LauncherConstants.constantURL("https://authserver.mojang.com/invalidate");
    private static final URL ROUTE_SIGNOUT = LauncherConstants.constantURL("https://authserver.mojang.com/signout");
    private static final String STORAGE_KEY_ACCESS_TOKEN = "accessToken";
    private final Gson gson = new Gson();
    private final Agent agent = Agent.MINECRAFT;
    private GameProfile[] profiles = null;
    private String accessToken = null;
    private boolean isOnline = false;

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank(this.getUsername()) && (StringUtils.isNotBlank(this.getPassword()) || StringUtils.isNotBlank(this.getAccessToken()));
    }

    @Override
    public void logIn() throws AuthenticationException {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isNotBlank(this.getAccessToken())) {
            this.logInWithToken();
        } else if (StringUtils.isNotBlank(this.getPassword())) {
            this.logInWithPassword();
        } else {
            throw new InvalidCredentialsException("Invalid password");
        }
    }

    protected void logInWithPassword() throws AuthenticationException {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        Launcher.getInstance().println("Logging in with username & password");
        AuthenticationRequest request = new AuthenticationRequest(this, this.getPassword());
        AuthenticationResponse response = this.makeRequest(ROUTE_AUTHENTICATE, request, AuthenticationResponse.class);
        if (!response.getClientToken().equals(this.getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.accessToken = response.getAccessToken();
        this.profiles = response.getAvailableProfiles();
        this.setSelectedProfile(response.getSelectedProfile());
        if (this.getSelectedProfile() == null && ArrayUtils.isNotEmpty(this.profiles)) {
            this.selectGameProfile(this.profiles[0]);
        }
        this.fireAuthenticationChangedEvent();
    }

    protected void logInWithToken() throws AuthenticationException {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getAccessToken())) {
            throw new InvalidCredentialsException("Invalid access token");
        }
        Launcher.getInstance().println("Logging in with access token");
        RefreshRequest request = new RefreshRequest(this);
        RefreshResponse response = this.makeRequest(ROUTE_REFRESH, request, RefreshResponse.class);
        if (!response.getClientToken().equals(this.getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.accessToken = response.getAccessToken();
        this.profiles = response.getAvailableProfiles();
        this.setSelectedProfile(response.getSelectedProfile());
        if (this.getSelectedProfile() == null && ArrayUtils.isNotEmpty(this.profiles)) {
            this.selectGameProfile(this.profiles[0]);
        }
        this.fireAuthenticationChangedEvent();
    }

    protected <T extends Response> T makeRequest(URL url, Object input, Class<T> classOfT) throws AuthenticationException {
        try {
            String jsonResult = Http.performPost(url, this.gson.toJson(input), Launcher.getInstance().getProxy(), "application/json", true);
            Response result = (Response)this.gson.fromJson(jsonResult, classOfT);
            if (result == null) {
                return null;
            }
            if (StringUtils.isNotBlank(result.getError())) {
                if (result.getError().equals("ForbiddenOperationException")) {
                    throw new InvalidCredentialsException(result.getErrorMessage());
                }
                throw new AuthenticationException(result.getErrorMessage());
            }
            this.isOnline = true;
            return (T)result;
        }
        catch (IOException e) {
            throw new AuthenticationException("Cannot contact authentication server", e);
        }
    }

    @Override
    public void logOut() {
        super.logOut();
        if (StringUtils.isNotBlank(this.getClientToken()) && StringUtils.isNotBlank(this.getAccessToken())) {
            Launcher.getInstance().println("Invalidating accessToken with server...");
            try {
                this.makeRequest(ROUTE_INVALIDATE, new InvalidateRequest(this), Response.class);
            }
            catch (AuthenticationException e) {
                Launcher.getInstance().println("Couldn't invalidate token on server", e);
            }
        }
        this.accessToken = null;
        this.profiles = null;
        this.isOnline = false;
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        return this.profiles;
    }

    @Override
    public boolean isLoggedIn() {
        return StringUtils.isNotBlank(this.accessToken);
    }

    @Override
    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.isOnline;
    }

    @Override
    public void selectGameProfile(GameProfile profile) throws AuthenticationException {
        if (!this.isLoggedIn()) {
            throw new AuthenticationException("Cannot change game profile whilst not logged in");
        }
        if (this.getSelectedProfile() != null) {
            throw new AuthenticationException("Cannot change game profile. You must log out and back in.");
        }
        if (profile == null || !ArrayUtils.contains(this.profiles, profile)) {
            throw new IllegalArgumentException("Invalid profile '" + profile + "'");
        }
        RefreshRequest request = new RefreshRequest(this, profile);
        RefreshResponse response = this.makeRequest(ROUTE_REFRESH, request, RefreshResponse.class);
        if (!response.getClientToken().equals(this.getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.accessToken = response.getAccessToken();
        this.setSelectedProfile(response.getSelectedProfile());
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public void loadFromStorage(Map<String, String> credentials) {
        super.loadFromStorage(credentials);
        this.accessToken = credentials.get(STORAGE_KEY_ACCESS_TOKEN);
    }

    @Override
    public Map<String, String> saveForStorage() {
        Map<String, String> result = super.saveForStorage();
        if (!this.shouldRememberMe()) {
            return result;
        }
        if (StringUtils.isNotBlank(this.getAccessToken())) {
            result.put(STORAGE_KEY_ACCESS_TOKEN, this.getAccessToken());
        }
        return result;
    }

    @Override
    public String getSessionToken() {
        if (this.isLoggedIn() && this.getSelectedProfile() != null && this.canPlayOnline()) {
            return String.format("token:%s:%s", this.getAccessToken(), this.getSelectedProfile().getId());
        }
        return null;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getClientToken() {
        return Launcher.getInstance().getClientToken().toString();
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public String toString() {
        return "YggdrasilAuthenticationService{agent=" + this.agent + ", profiles=" + Arrays.toString(this.profiles) + ", selectedProfile=" + this.getSelectedProfile() + ", sessionToken='" + this.getSessionToken() + '\'' + ", username='" + this.getUsername() + '\'' + ", isLoggedIn=" + this.isLoggedIn() + ", canPlayOnline=" + this.canPlayOnline() + ", accessToken='" + this.accessToken + '\'' + ", clientToken='" + this.getClientToken() + '\'' + '}';
    }
}

