/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;

public class AuthenticationDatabase {
    public static final String DEMO_UUID_PREFIX = "demo-";
    private final Map<String, AuthenticationService> authById;

    public AuthenticationDatabase() {
        this(new HashMap<String, AuthenticationService>());
    }

    public AuthenticationDatabase(Map<String, AuthenticationService> authById) {
        this.authById = authById;
    }

    public AuthenticationService getByName(String name) {
        if (name == null) {
            return null;
        }
        for (Map.Entry<String, AuthenticationService> entry : this.authById.entrySet()) {
            GameProfile profile = entry.getValue().getSelectedProfile();
            if (profile != null && profile.getName().equals(name)) {
                return entry.getValue();
            }
            if (profile != null || !AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()).equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public AuthenticationService getByUUID(String uuid) {
        return this.authById.get(uuid);
    }

    public Collection<String> getKnownNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, AuthenticationService> entry : this.authById.entrySet()) {
            GameProfile profile = entry.getValue().getSelectedProfile();
            if (profile != null) {
                names.add(profile.getName());
                continue;
            }
            names.add(AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()));
        }
        return names;
    }

    public void register(String uuid, AuthenticationService authentication) {
        this.authById.put(uuid, authentication);
    }

    public Set<String> getknownUUIDs() {
        return this.authById.keySet();
    }

    public void removeUUID(String uuid) {
        this.authById.remove(uuid);
    }

    public static String getUserFromDemoUUID(String uuid) {
        if (uuid.startsWith(DEMO_UUID_PREFIX) && uuid.length() > DEMO_UUID_PREFIX.length()) {
            return "Demo User " + uuid.substring(DEMO_UUID_PREFIX.length());
        }
        return "Demo User";
    }

    public static class Serializer
    implements JsonDeserializer<AuthenticationDatabase>,
    JsonSerializer<AuthenticationDatabase> {
        @Override
        public AuthenticationDatabase deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TypeToken<HashMap<String, Map<String, String>>> token = new TypeToken<HashMap<String, Map<String, String>>>(){};
            HashMap<String, AuthenticationService> services = new HashMap<String, AuthenticationService>();
            Map credentials = (Map)context.deserialize(json, token.getType());
            for (Map.Entry entry : credentials.entrySet()) {
                YggdrasilAuthenticationService service = new YggdrasilAuthenticationService();
                service.loadFromStorage((Map)entry.getValue());
                services.put((String)entry.getKey(), service);
            }
            return new AuthenticationDatabase(services);
        }

        @Override
        public JsonElement serialize(AuthenticationDatabase src, Type typeOfSrc, JsonSerializationContext context) {
            Map services = src.authById;
            HashMap credentials = new HashMap();
            for (Map.Entry entry : services.entrySet()) {
                credentials.put(entry.getKey(), ((AuthenticationService)entry.getValue()).saveForStorage());
            }
            return context.serialize(credentials);
        }
    }
}

