/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import net.minecraft.hopper.Util;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.BaseAuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.exceptions.InvalidCredentialsException;
import org.apache.commons.lang3.StringUtils;

public class LegacyAuthenticationService
extends BaseAuthenticationService {
    private static final URL AUTHENTICATION_URL = Util.constantURL("https://login.minecraft.net");
    private static final int AUTHENTICATION_VERSION = 14;
    private static final int RESPONSE_PART_PROFILE_NAME = 2;
    private static final int RESPONSE_PART_SESSION_TOKEN = 3;
    private static final int RESPONSE_PART_PROFILE_ID = 4;
    private String sessionToken;

    @Override
    public void logIn() throws AuthenticationException {
        String sessionToken;
        String profileName;
        String profileId;
        String response;
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("user", this.getUsername());
        args.put("password", this.getPassword());
        args.put("version", 14);
        try {
            response = Http.performPost(AUTHENTICATION_URL, args, Launcher.getInstance().getProxy()).trim();
        }
        catch (IOException e) {
            throw new AuthenticationException("Authentication server is not responding", e);
        }
        String[] split = response.split(":");
        if (split.length == 5) {
            profileId = split[4];
            profileName = split[2];
            sessionToken = split[3];
            if (StringUtils.isBlank(profileId) || StringUtils.isBlank(profileName) || StringUtils.isBlank(sessionToken)) {
                throw new AuthenticationException("Unknown response from authentication server: " + response);
            }
        } else {
            throw new InvalidCredentialsException(response);
        }
        this.setSelectedProfile(new GameProfile(profileId, profileName));
        this.sessionToken = sessionToken;
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public void logOut() {
        super.logOut();
        this.sessionToken = null;
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        if (this.getSelectedProfile() != null) {
            return new GameProfile[]{this.getSelectedProfile()};
        }
        return new GameProfile[0];
    }

    @Override
    public void selectGameProfile(GameProfile profile) throws AuthenticationException {
        throw new UnsupportedOperationException("Game profiles cannot be changed in the legacy authentication service");
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }
}

