/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.io.File;
import java.util.Map;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.LegacyAuthenticationService;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.launcher.events.AuthenticationChangedListener;

public class LoadTestingAuthenticationService
implements AuthenticationService {
    private final AuthenticationService primary = new LegacyAuthenticationService();
    private final AuthenticationService secondary = new YggdrasilAuthenticationService();

    @Override
    public void logIn() throws AuthenticationException {
        this.primary.logIn();
        try {
            this.secondary.logIn();
        }
        catch (AuthenticationException e) {
            Launcher.getInstance().println("Couldn't load-test new authentication service (method: logIn)", e);
        }
    }

    @Override
    public boolean canLogIn() {
        return this.primary.canLogIn();
    }

    @Override
    public void logOut() {
        this.primary.logOut();
        this.secondary.logOut();
    }

    @Override
    public boolean isLoggedIn() {
        return this.primary.isLoggedIn();
    }

    @Override
    public boolean canPlayOnline() {
        return this.primary.canPlayOnline();
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        return this.primary.getAvailableProfiles();
    }

    @Override
    public GameProfile getSelectedProfile() {
        return this.primary.getSelectedProfile();
    }

    @Override
    public void selectGameProfile(GameProfile profile) throws AuthenticationException {
        this.primary.selectGameProfile(profile);
        try {
            this.secondary.selectGameProfile(profile);
        }
        catch (AuthenticationException e) {
            Launcher.getInstance().println("Couldn't load-test new authentication service (method: selectGameProfile)", e);
        }
    }

    @Override
    public void loadFromStorage(Map<String, String> credentials) {
        this.primary.loadFromStorage(credentials);
        this.secondary.loadFromStorage(credentials);
    }

    @Override
    public Map<String, String> saveForStorage() {
        return this.primary.saveForStorage();
    }

    @Override
    public String getSessionToken() {
        return this.primary.getSessionToken();
    }

    @Override
    public String getUsername() {
        return this.primary.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.primary.setUsername(username);
        this.secondary.setUsername(username);
    }

    @Override
    public void setPassword(String password) {
        this.primary.setPassword(password);
        this.secondary.setPassword(password);
    }

    @Override
    public void addAuthenticationChangedListener(AuthenticationChangedListener listener) {
        this.primary.addAuthenticationChangedListener(listener);
    }

    @Override
    public void removeAuthenticationChangedListener(AuthenticationChangedListener listener) {
        this.primary.removeAuthenticationChangedListener(listener);
    }

    @Override
    public String guessPasswordFromSillyOldFormat(File lastlogin) {
        return this.primary.guessPasswordFromSillyOldFormat(lastlogin);
    }

    @Override
    public void setRememberMe(boolean rememberMe) {
        this.primary.setRememberMe(rememberMe);
        this.secondary.setRememberMe(rememberMe);
    }

    @Override
    public boolean shouldRememberMe() {
        return this.primary.shouldRememberMe();
    }
}

