/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessRunnable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessMonitorThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JavaProcess process;

    public ProcessMonitorThread(JavaProcess process) {
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader reader = new InputStreamReader(this.process.getRawProcess().getInputStream());
        BufferedReader buf = new BufferedReader(reader);
        String line = null;
        while (this.process.isRunning()) {
            try {
                while ((line = buf.readLine()) != null) {
                    LOGGER.info("Client> " + line);
                    if (this.process.getSysOutFilter().apply(line) != Boolean.TRUE) continue;
                    this.process.getSysOutLines().add(line);
                }
            }
            catch (IOException ex) {
                LOGGER.error(ex);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
        JavaProcessRunnable onExit = this.process.getExitRunnable();
        if (onExit != null) {
            onExit.onJavaProcessEnded(this.process);
        }
    }
}

