/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.updater.download.ChecksummedDownloadable;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Version;

public class CompleteVersion
implements Version {
    private String id;
    private Date time;
    private Date releaseTime;
    private ReleaseType type;
    private String minecraftArguments;
    private List<Library> libraries;
    private String mainClass;
    private int minimumLauncherVersion;
    private String incompatibilityReason;
    private String assets;
    private List<Rule> rules;
    private transient boolean synced = false;

    public CompleteVersion() {
    }

    public CompleteVersion(String id, Date releaseTime, Date updateTime, ReleaseType type, String mainClass, String minecraftArguments) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("ID cannot be null or empty");
        }
        if (releaseTime == null) {
            throw new IllegalArgumentException("Release time cannot be null");
        }
        if (updateTime == null) {
            throw new IllegalArgumentException("Update time cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        if (mainClass == null || mainClass.length() == 0) {
            throw new IllegalArgumentException("Main class cannot be null or empty");
        }
        if (minecraftArguments == null) {
            throw new IllegalArgumentException("Process arguments cannot be null or empty");
        }
        this.id = id;
        this.releaseTime = releaseTime;
        this.time = updateTime;
        this.type = type;
        this.mainClass = mainClass;
        this.libraries = new ArrayList<Library>();
        this.minecraftArguments = minecraftArguments;
    }

    public CompleteVersion(CompleteVersion version) {
        this(version.getId(), version.getReleaseTime(), version.getUpdatedTime(), version.getType(), version.getMainClass(), version.getMinecraftArguments());
        this.minimumLauncherVersion = version.minimumLauncherVersion;
        this.incompatibilityReason = version.incompatibilityReason;
        for (Library library : version.getLibraries()) {
            this.libraries.add(new Library(library));
        }
    }

    public CompleteVersion(Version version, String mainClass, String minecraftArguments) {
        this(version.getId(), version.getReleaseTime(), version.getUpdatedTime(), version.getType(), mainClass, minecraftArguments);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setUpdatedTime(Date time) {
        if (time == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.time = time;
    }

    @Override
    public void setReleaseTime(Date time) {
        if (time == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.releaseTime = time;
    }

    @Override
    public void setType(ReleaseType type) {
        if (type == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        this.type = type;
    }

    public void setMainClass(String mainClass) {
        if (mainClass == null || mainClass.length() == 0) {
            throw new IllegalArgumentException("Main class cannot be null or empty");
        }
        this.mainClass = mainClass;
    }

    public Collection<Library> getRelevantLibraries() {
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : this.libraries) {
            if (!library.appliesToCurrentEnvironment()) continue;
            result.add(library);
        }
        return result;
    }

    public Collection<File> getClassPath(OperatingSystem os, File base) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<File> result = new ArrayList<File>();
        for (Library library : libraries) {
            if (library.getNatives() != null) continue;
            result.add(new File(base, "libraries/" + library.getArtifactPath()));
        }
        result.add(new File(base, "versions/" + this.getId() + "/" + this.getId() + ".jar"));
        return result;
    }

    public Collection<String> getExtractFiles(OperatingSystem os) {
        Collection<Library> libraries = this.getRelevantLibraries();
        ArrayList<String> result = new ArrayList<String>();
        for (Library library : libraries) {
            Map<OperatingSystem, String> natives = library.getNatives();
            if (natives == null || !natives.containsKey((Object)os)) continue;
            result.add("libraries/" + library.getArtifactPath(natives.get((Object)os)));
        }
        return result;
    }

    public Set<String> getRequiredFiles(OperatingSystem os) {
        HashSet<String> neededFiles = new HashSet<String>();
        for (Library library : this.getRelevantLibraries()) {
            if (library.getNatives() != null) {
                String natives = library.getNatives().get((Object)os);
                if (natives == null) continue;
                neededFiles.add("libraries/" + library.getArtifactPath(natives));
                continue;
            }
            neededFiles.add("libraries/" + library.getArtifactPath());
        }
        return neededFiles;
    }

    public Set<Downloadable> getRequiredDownloadables(OperatingSystem os, Proxy proxy, File targetDirectory, boolean ignoreLocalFiles) throws MalformedURLException {
        HashSet<Downloadable> neededFiles = new HashSet<Downloadable>();
        for (Library library : this.getRelevantLibraries()) {
            String file = null;
            if (library.getNatives() != null) {
                String natives = library.getNatives().get((Object)os);
                if (natives != null) {
                    file = library.getArtifactPath(natives);
                }
            } else {
                file = library.getArtifactPath();
            }
            if (file == null) continue;
            URL url = new URL(library.getDownloadUrl() + file);
            File local = new File(targetDirectory, "libraries/" + file);
            if (local.isFile() && library.hasCustomUrl()) continue;
            neededFiles.add(new ChecksummedDownloadable(proxy, url, local, ignoreLocalFiles));
        }
        return neededFiles;
    }

    public String toString() {
        return "CompleteVersion{id='" + this.id + '\'' + ", updatedTime=" + this.time + ", releasedTime=" + this.time + ", type=" + (Object)((Object)this.type) + ", libraries=" + this.libraries + ", mainClass='" + this.mainClass + '\'' + ", minimumLauncherVersion=" + this.minimumLauncherVersion + '}';
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String minecraftArguments) {
        if (minecraftArguments == null) {
            throw new IllegalArgumentException("Process arguments cannot be null or empty");
        }
        this.minecraftArguments = minecraftArguments;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public void setMinimumLauncherVersion(int minimumLauncherVersion) {
        this.minimumLauncherVersion = minimumLauncherVersion;
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule rule : this.rules) {
            Rule.Action action = rule.getAppliedAction();
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public void setIncompatibilityReason(String incompatibilityReason) {
        this.incompatibilityReason = incompatibilityReason;
    }

    public String getIncompatibilityReason() {
        return this.incompatibilityReason;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public String getAssets() {
        return this.assets;
    }

    public void setAssets(String assets) {
        this.assets = assets;
    }
}

