/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import com.mojang.util.QueueLogAppender;
import java.awt.Font;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.launcher.Launcher;

public class ConsoleTab
extends JScrollPane {
    private static final Font MONOSPACED = new Font("Monospaced", 0, 12);
    private final JTextPane console = new JTextPane();
    private final Launcher launcher;

    public ConsoleTab(Launcher launcher) {
        this.launcher = launcher;
        this.console.setFont(MONOSPACED);
        this.console.setEditable(false);
        this.console.setMargin(null);
        this.setViewportView(this.console);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String line;
                while ((line = QueueLogAppender.getNextLogEvent("DevelopmentConsole")) != null) {
                    ConsoleTab.this.print(line);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void print(final String line) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleTab.this.print(line);
                }
            });
            return;
        }
        Document document = this.console.getDocument();
        JScrollBar scrollBar = this.getVerticalScrollBar();
        boolean shouldScroll = false;
        if (this.getViewport().getView() == this.console) {
            shouldScroll = (double)scrollBar.getValue() + scrollBar.getSize().getHeight() + (double)(MONOSPACED.getSize() * 4) > (double)scrollBar.getMaximum();
        }
        try {
            document.insertString(document.getLength(), line, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (shouldScroll) {
            scrollBar.setValue(Integer.MAX_VALUE);
        }
    }
}

