/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.version;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.minecraft.launcher.ui.popups.version.VersionEditorPopup;

public class VersionRequirementsPanel
extends JPanel {
    private final VersionEditorPopup editor;
    private final JSpinner launcherVersion = new JSpinner();
    private final JTextField incompatibilityWarning = new JTextField();

    public VersionRequirementsPanel(VersionEditorPopup editor) {
        this.editor = editor;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Compatibility Requirements"));
        this.createInterface();
        this.fillDefaultValues();
        this.addEventHandlers();
    }

    protected void createInterface() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 17;
        constraints.gridy = 0;
        JPanel launcherPanel = new JPanel();
        launcherPanel.setLayout(new BoxLayout(launcherPanel, 0));
        launcherPanel.add(this.launcherVersion);
        launcherPanel.add(Box.createHorizontalStrut(5));
        launcherPanel.add(new JLabel("(Current version, 1.3.4, is numerical 11)"));
        this.add((Component)new JLabel("Required Launcher:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)launcherPanel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)new JLabel("Incompatibility Reason:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.incompatibilityWarning, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
    }

    protected void fillDefaultValues() {
        this.launcherVersion.setValue(this.editor.getVersion().getMinimumLauncherVersion());
        this.incompatibilityWarning.setText(this.editor.getVersion().getIncompatibilityReason());
    }

    protected void addEventHandlers() {
        this.launcherVersion.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VersionRequirementsPanel.this.editor.getVersion().setMinimumLauncherVersion((Integer)VersionRequirementsPanel.this.launcherVersion.getValue());
            }
        });
        this.incompatibilityWarning.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VersionRequirementsPanel.this.updateIncompatibilityWarning();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VersionRequirementsPanel.this.updateIncompatibilityWarning();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VersionRequirementsPanel.this.updateIncompatibilityWarning();
            }
        });
    }

    private void updateIncompatibilityWarning() {
        this.editor.getVersion().setIncompatibilityReason(this.incompatibilityWarning.getText().length() == 0 ? null : this.incompatibilityWarning.getText());
    }
}

