/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.events.RefreshedVersionsListener;
import net.minecraft.launcher.ui.popups.version.VersionEditorPopup;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;

public class VersionListTab
extends JScrollPane
implements RefreshedVersionsListener {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_RELEASE_DATE = 2;
    private static final int COLUMN_UPDATE_DATE = 3;
    private static final int COLUMN_LIBRARIES = 4;
    private static final int COLUMN_STATUS = 5;
    private static final int NUM_COLUMNS = 6;
    private final Launcher launcher;
    private final VersionTableModel dataModel = new VersionTableModel();
    private final JTable table = new JTable(this.dataModel);
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JMenuItem browseVersionFolder = new JMenuItem("Open Versions Folder");

    public VersionListTab(Launcher launcher) {
        this.launcher = launcher;
        this.setViewportView(this.table);
        this.createInterface();
        launcher.getVersionManager().addRefreshedVersionsListener(this);
    }

    protected void createInterface() {
        this.popupMenu.add(this.browseVersionFolder);
        this.table.setComponentPopupMenu(this.popupMenu);
        this.table.setFillsViewportHeight(true);
        this.browseVersionFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OperatingSystem.openFolder(new File(VersionListTab.this.launcher.getWorkingDirectory(), "/versions/"));
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = VersionListTab.this.table.getSelectedRow()) >= 0 && row < VersionListTab.this.dataModel.versions.size() && VersionListTab.this.dataModel.versions.get(row) instanceof CompleteVersion) {
                    VersionEditorPopup.showEditVersionDialog(VersionListTab.this.getLauncher(), (CompleteVersion)VersionListTab.this.dataModel.versions.get(row));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    int r = VersionListTab.this.table.rowAtPoint(e.getPoint());
                    if (r >= 0 && r < VersionListTab.this.table.getRowCount()) {
                        VersionListTab.this.table.setRowSelectionInterval(r, r);
                    } else {
                        VersionListTab.this.table.clearSelection();
                    }
                    VersionListTab.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    int r = VersionListTab.this.table.rowAtPoint(e.getPoint());
                    if (r >= 0 && r < VersionListTab.this.table.getRowCount()) {
                        VersionListTab.this.table.setRowSelectionInterval(r, r);
                    } else {
                        VersionListTab.this.table.clearSelection();
                    }
                    VersionListTab.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        this.dataModel.setVersions(manager.getLocalVersionList().getVersions());
    }

    @Override
    public boolean shouldReceiveEventsInUIThread() {
        return true;
    }

    private class VersionTableModel
    extends AbstractTableModel {
        private final List<Version> versions = new ArrayList<Version>();

        private VersionTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.versions.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3 || columnIndex == 2) {
                return Date.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 3: {
                    return "Last modified";
                }
                case 1: {
                    return "Version type";
                }
                case 4: {
                    return "Library count";
                }
                case 0: {
                    return "Version name";
                }
                case 5: {
                    return "Sync status";
                }
                case 2: {
                    return "Release Date";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Version version = this.versions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return version.getId();
                }
                case 3: {
                    return version.getUpdatedTime();
                }
                case 4: {
                    if (version instanceof CompleteVersion) {
                        int relevant;
                        CompleteVersion complete = (CompleteVersion)version;
                        int total = complete.getLibraries().size();
                        if (total == (relevant = complete.getRelevantLibraries().size())) {
                            return total;
                        }
                        return String.format("%d (%d relevant to %s)", total, relevant, OperatingSystem.getCurrentPlatform().getName());
                    }
                    return "?";
                }
                case 5: {
                    VersionSyncInfo syncInfo = VersionListTab.this.launcher.getVersionManager().getVersionSyncInfo(version);
                    if (syncInfo.isOnRemote()) {
                        if (syncInfo.isUpToDate()) {
                            return "Up to date with remote";
                        }
                        return "Update avail from remote";
                    }
                    return "Local only";
                }
                case 1: {
                    return version.getType().getName();
                }
                case 2: {
                    return version.getReleaseTime();
                }
            }
            return null;
        }

        public void setVersions(Collection<Version> versions) {
            this.versions.clear();
            this.versions.addAll(versions);
            this.fireTableDataChanged();
        }
    }
}

