/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.updater.download.MonitoringInputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ChecksummedDownloadable
extends Downloadable {
    private String checksum;

    public ChecksummedDownloadable(Proxy proxy, URL remoteFile, File localFile, boolean forceDownload) {
        super(proxy, remoteFile, localFile, forceDownload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String download() throws IOException {
        InputStream inputStream;
        int status;
        HttpURLConnection connection;
        block20: {
            ++this.numAttempts;
            this.ensureFileWritable();
            File target = this.getTarget();
            File checksumFile = new File(target.getAbsolutePath() + ".sha");
            String localHash = null;
            if (target.isFile()) {
                localHash = ChecksummedDownloadable.getDigest(target, "SHA", 40);
            }
            if (target.isFile() && checksumFile.isFile()) {
                this.checksum = this.readFile(checksumFile, "");
                if (this.checksum.length() == 0 || this.checksum.trim().equalsIgnoreCase(localHash)) {
                    return "Local file matches local checksum, using that";
                }
                this.checksum = null;
                FileUtils.deleteQuietly(checksumFile);
            }
            if (this.checksum == null) {
                try {
                    connection = this.makeConnection(new URL(this.getUrl().toString() + ".sha1"));
                    status = connection.getResponseCode();
                    if (status / 100 == 2) {
                        inputStream = connection.getInputStream();
                        try {
                            this.checksum = IOUtils.toString(inputStream, Charsets.UTF_8);
                            FileUtils.writeStringToFile(checksumFile, this.checksum);
                            break block20;
                        }
                        catch (IOException e) {
                            this.checksum = "";
                            break block20;
                        }
                        finally {
                            IOUtils.closeQuietly(inputStream);
                        }
                    }
                    this.checksum = checksumFile.isFile() ? this.readFile(checksumFile, "") : "";
                }
                catch (IOException e) {
                    if (target.isFile()) {
                        this.checksum = this.readFile(checksumFile, "");
                    }
                    throw e;
                }
            }
        }
        try {
            connection = this.makeConnection(this.getUrl());
            status = connection.getResponseCode();
            if (status / 100 == 2) {
                this.updateExpectedSize(connection);
                inputStream = new MonitoringInputStream(connection.getInputStream(), this.getMonitor());
                FileOutputStream outputStream = new FileOutputStream(this.getTarget());
                String digest = ChecksummedDownloadable.copyAndDigest(inputStream, outputStream, "SHA", 40);
                if (this.checksum == null || this.checksum.length() == 0) {
                    return "Didn't have checksum so assuming our copy is good";
                }
                if (this.checksum.trim().equalsIgnoreCase(digest)) {
                    return "Downloaded successfully and checksum matched";
                }
                throw new RuntimeException(String.format("Checksum did not match downloaded file (Checksum was %s, downloaded %s)", this.checksum, digest));
            }
            if (this.getTarget().isFile()) {
                return "Couldn't connect to server (responded with " + status + ") but have local file, assuming it's good";
            }
            throw new RuntimeException("Server responded with " + status);
        }
        catch (IOException e) {
            if (this.getTarget().isFile()) {
                return "Couldn't connect to server (" + e.getClass().getSimpleName() + ": '" + e.getMessage() + "') but have local file, assuming it's good";
            }
            throw e;
        }
    }

    private String readFile(File file, String def) {
        try {
            return FileUtils.readFileToString(file);
        }
        catch (Throwable ignored) {
            return def;
        }
    }
}

