/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.applet.Applet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import net.minecraft.Launcher;
import net.minecraft.Util;

public class GameUpdater
implements Runnable {
    public static final int STATE_INIT = 1;
    public static final int STATE_DETERMINING_PACKAGES = 2;
    public static final int STATE_CHECKING_CACHE = 3;
    public static final int STATE_DOWNLOADING = 4;
    public static final int STATE_EXTRACTING_PACKAGES = 5;
    public static final int STATE_UPDATING_CLASSPATH = 6;
    public static final int STATE_SWITCHING_APPLET = 7;
    public static final int STATE_INITIALIZE_REAL_APPLET = 8;
    public static final int STATE_START_REAL_APPLET = 9;
    public static final int STATE_DONE = 10;
    public int percentage;
    public int currentSizeDownload;
    public int totalSizeDownload;
    public int currentSizeExtract;
    public int totalSizeExtract;
    protected URL[] urlList;
    private static ClassLoader classLoader;
    protected Thread loaderThread;
    protected Thread animationThread;
    public boolean fatalError;
    public String fatalErrorDescription;
    protected String subtaskMessage = "";
    protected int state = 1;
    protected boolean lzmaSupported = false;
    protected boolean pack200Supported = false;
    protected String[] genericErrorMessage = new String[]{"An error occured while loading the applet.", "Please contact support to resolve this issue.", "<placeholder for error message>"};
    protected boolean certificateRefused;
    protected String[] certificateRefusedMessage = new String[]{"Permissions for Applet Refused.", "Please accept the permissions dialog to allow", "the applet to continue the loading process."};
    protected static boolean natives_loaded;
    private String latestVersion;
    private String mainGameUrl;

    static {
        natives_loaded = false;
    }

    public GameUpdater(String latestVersion, String mainGameUrl) {
        this.latestVersion = latestVersion;
        this.mainGameUrl = mainGameUrl;
    }

    public void init() {
        this.state = 1;
        try {
            Class.forName("LZMA.LzmaInputStream");
            this.lzmaSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Pack200.class.getSimpleName();
            this.pack200Supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String generateStacktrace(Exception exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    protected String getDescriptionForState() {
        switch (this.state) {
            case 1: {
                return "Initializing loader";
            }
            case 2: {
                return "Determining packages to load";
            }
            case 3: {
                return "Checking cache for existing files";
            }
            case 4: {
                return "Downloading packages";
            }
            case 5: {
                return "Extracting downloaded packages";
            }
            case 6: {
                return "Updating classpath";
            }
            case 7: {
                return "Switching applet";
            }
            case 8: {
                return "Initializing real applet";
            }
            case 9: {
                return "Starting real applet";
            }
            case 10: {
                return "Done loading";
            }
        }
        return "unknown state";
    }

    protected String trimExtensionByCapabilities(String file) {
        if (!this.pack200Supported) {
            file = file.replaceAll(".pack", "");
        }
        if (!this.lzmaSupported) {
            file = file.replaceAll(".lzma", "");
        }
        return file;
    }

    protected void loadJarURLs() throws Exception {
        this.state = 2;
        String jarList = "lwjgl.jar.lzma, jinput.jar.lzma, lwjgl_util.jar.lzma, " + this.mainGameUrl;
        jarList = this.trimExtensionByCapabilities(jarList);
        StringTokenizer jar = new StringTokenizer(jarList, ", ");
        int jarCount = jar.countTokens() + 1;
        this.urlList = new URL[jarCount];
        URL path = new URL("http://s3.amazonaws.com/MinecraftDownload/");
        int i = 0;
        while (i < jarCount - 1) {
            this.urlList[i] = new URL(path, jar.nextToken());
            ++i;
        }
        String osName = System.getProperty("os.name");
        String nativeJar = null;
        if (osName.startsWith("Win")) {
            nativeJar = "windows_natives.jar.lzma";
        } else if (osName.startsWith("Linux")) {
            nativeJar = "linux_natives.jar.lzma";
        } else if (osName.startsWith("Mac")) {
            nativeJar = "macosx_natives.jar.lzma";
        } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            nativeJar = "solaris_natives.jar.lzma";
        } else {
            this.fatalErrorOccured("OS (" + osName + ") not supported", null);
        }
        if (nativeJar == null) {
            this.fatalErrorOccured("no lwjgl natives files found", null);
        } else {
            nativeJar = this.trimExtensionByCapabilities(nativeJar);
            this.urlList[jarCount - 1] = new URL(path, nativeJar);
        }
    }

    public void run() {
        this.init();
        this.state = 3;
        this.percentage = 5;
        try {
            try {
                this.loadJarURLs();
                String path = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Util.getWorkingDirectory() + File.separator + "bin" + File.separator;
                    }
                });
                File dir = new File(path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (this.latestVersion != null) {
                    File versionFile = new File(dir, "version");
                    boolean cacheAvailable = false;
                    if (versionFile.exists() && (this.latestVersion.equals("-1") || this.latestVersion.equals(this.readVersionFile(versionFile)))) {
                        cacheAvailable = true;
                        this.percentage = 90;
                    }
                    if (!cacheAvailable) {
                        this.downloadJars(path);
                        this.extractJars(path);
                        this.extractNatives(path);
                        if (this.latestVersion != null) {
                            this.percentage = 90;
                            this.writeVersionFile(versionFile, this.latestVersion);
                        }
                    }
                }
                this.updateClassPath(dir);
                this.state = 10;
            }
            catch (AccessControlException ace) {
                this.fatalErrorOccured(ace.getMessage(), ace);
                this.certificateRefused = true;
                this.loaderThread = null;
            }
            catch (Exception e) {
                this.fatalErrorOccured(e.getMessage(), e);
                this.loaderThread = null;
            }
        }
        finally {
            this.loaderThread = null;
        }
    }

    protected String readVersionFile(File file) throws Exception {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        String version = dis.readUTF();
        dis.close();
        return version;
    }

    protected void writeVersionFile(File file, String version) throws Exception {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        dos.writeUTF(version);
        dos.close();
    }

    protected void updateClassPath(File dir) throws Exception {
        String path;
        this.state = 6;
        this.percentage = 95;
        URL[] urls = new URL[this.urlList.length];
        int i = 0;
        while (i < this.urlList.length) {
            urls[i] = new File(dir, this.getJarName(this.urlList[i])).toURI().toURL();
            ++i;
        }
        if (classLoader == null) {
            classLoader = new URLClassLoader(urls){

                protected PermissionCollection getPermissions(CodeSource codesource) {
                    PermissionCollection perms = null;
                    try {
                        Method method = SecureClassLoader.class.getDeclaredMethod("getPermissions", CodeSource.class);
                        method.setAccessible(true);
                        perms = (PermissionCollection)method.invoke((Object)this.getClass().getClassLoader(), codesource);
                        String host = "www.minecraft.net";
                        if (host != null && host.length() > 0) {
                            perms.add(new SocketPermission(host, "connect,accept"));
                        } else {
                            codesource.getLocation().getProtocol().equals("file");
                        }
                        perms.add(new FilePermission("<<ALL FILES>>", "read"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return perms;
                }
            };
        }
        if (!(path = dir.getAbsolutePath()).endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        this.unloadNatives(path);
        System.setProperty("org.lwjgl.librarypath", String.valueOf(path) + "natives");
        System.setProperty("net.java.games.input.librarypath", String.valueOf(path) + "natives");
        natives_loaded = true;
    }

    private void unloadNatives(String nativePath) {
        if (!natives_loaded) {
            return;
        }
        try {
            Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            field.setAccessible(true);
            Vector libs = (Vector)field.get(this.getClass().getClassLoader());
            String path = new File(nativePath).getCanonicalPath();
            int i = 0;
            while (i < libs.size()) {
                String s = (String)libs.get(i);
                if (s.startsWith(path)) {
                    libs.remove(i);
                    --i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Applet createApplet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> appletClass = classLoader.loadClass("net.minecraft.client.MinecraftApplet");
        return (Applet)appletClass.newInstance();
    }

    protected void downloadJars(String path) throws Exception {
        URLConnection urlconnection;
        this.state = 4;
        int[] fileSizes = new int[this.urlList.length];
        int i = 0;
        while (i < this.urlList.length) {
            System.out.println(this.urlList[i]);
            urlconnection = this.urlList[i].openConnection();
            urlconnection.setDefaultUseCaches(false);
            if (urlconnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlconnection).setRequestMethod("HEAD");
            }
            fileSizes[i] = urlconnection.getContentLength();
            this.totalSizeDownload += fileSizes[i];
            ++i;
        }
        this.percentage = 10;
        int initialPercentage = 10;
        byte[] buffer = new byte[65536];
        int i2 = 0;
        while (i2 < this.urlList.length) {
            int unsuccessfulAttempts = 0;
            int maxUnsuccessfulAttempts = 3;
            boolean downloadFile = true;
            while (downloadFile) {
                int bufferSize;
                downloadFile = false;
                urlconnection = this.urlList[i2].openConnection();
                if (urlconnection instanceof HttpURLConnection) {
                    urlconnection.setRequestProperty("Cache-Control", "no-cache");
                    urlconnection.connect();
                }
                String currentFile = this.getFileName(this.urlList[i2]);
                InputStream inputstream = this.getJarInputStream(currentFile, urlconnection);
                FileOutputStream fos = new FileOutputStream(String.valueOf(path) + currentFile);
                long downloadStartTime = System.currentTimeMillis();
                int downloadedAmount = 0;
                int fileSize = 0;
                String downloadSpeedMessage = "";
                while ((bufferSize = inputstream.read(buffer, 0, buffer.length)) != -1) {
                    fos.write(buffer, 0, bufferSize);
                    this.currentSizeDownload += bufferSize;
                    fileSize += bufferSize;
                    this.percentage = initialPercentage + this.currentSizeDownload * 45 / this.totalSizeDownload;
                    this.subtaskMessage = "Retrieving: " + currentFile + " " + this.currentSizeDownload * 100 / this.totalSizeDownload + "%";
                    downloadedAmount += bufferSize;
                    long timeLapse = System.currentTimeMillis() - downloadStartTime;
                    if (timeLapse >= 1000L) {
                        float downloadSpeed = (float)downloadedAmount / (float)timeLapse;
                        downloadSpeed = (float)((int)(downloadSpeed * 100.0f)) / 100.0f;
                        downloadSpeedMessage = " @ " + downloadSpeed + " KB/sec";
                        downloadedAmount = 0;
                        downloadStartTime += 1000L;
                    }
                    this.subtaskMessage = String.valueOf(this.subtaskMessage) + downloadSpeedMessage;
                }
                inputstream.close();
                fos.close();
                if (!(urlconnection instanceof HttpURLConnection) || fileSize == fileSizes[i2] || fileSizes[i2] <= 0) continue;
                if (++unsuccessfulAttempts < maxUnsuccessfulAttempts) {
                    downloadFile = true;
                    this.currentSizeDownload -= fileSize;
                    continue;
                }
                throw new Exception("failed to download " + currentFile);
            }
            ++i2;
        }
        this.subtaskMessage = "";
    }

    protected InputStream getJarInputStream(String currentFile, final URLConnection urlconnection) throws Exception {
        final InputStream[] is = new InputStream[1];
        int j = 0;
        while (j < 3 && is[0] == null) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        is[0] = urlconnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.setName("JarInputStreamThread");
            t.start();
            int iterationCount = 0;
            while (is[0] == null && iterationCount++ < 5) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (is[0] == null) {
                try {
                    t.interrupt();
                    t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++j;
        }
        if (is[0] == null) {
            if (currentFile.equals("minecraft.jar")) {
                throw new Exception("Unable to download " + currentFile);
            }
            throw new Exception("Unable to download " + currentFile);
        }
        return is[0];
    }

    protected void extractLZMA(String in, String out) throws Exception {
        File f = new File(in);
        FileInputStream fileInputHandle = new FileInputStream(f);
        Class<?> clazz = Class.forName("LZMA.LzmaInputStream");
        Constructor<?> constructor = clazz.getDeclaredConstructor(InputStream.class);
        InputStream inputHandle = (InputStream)constructor.newInstance(fileInputHandle);
        FileOutputStream outputHandle = new FileOutputStream(out);
        byte[] buffer = new byte[16384];
        int ret = inputHandle.read(buffer);
        while (ret >= 1) {
            ((OutputStream)outputHandle).write(buffer, 0, ret);
            ret = inputHandle.read(buffer);
        }
        inputHandle.close();
        ((OutputStream)outputHandle).close();
        outputHandle = null;
        inputHandle = null;
        f.delete();
    }

    protected void extractPack(String in, String out) throws Exception {
        File f = new File(in);
        FileOutputStream fostream = new FileOutputStream(out);
        JarOutputStream jostream = new JarOutputStream(fostream);
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        unpacker.unpack(f, jostream);
        jostream.close();
        f.delete();
    }

    protected void extractJars(String path) throws Exception {
        this.state = 5;
        float increment = 10.0f / (float)this.urlList.length;
        int i = 0;
        while (i < this.urlList.length) {
            this.percentage = 55 + (int)(increment * (float)(i + 1));
            String filename = this.getFileName(this.urlList[i]);
            if (filename.endsWith(".pack.lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replaceAll(".lzma", "");
                this.extractLZMA(String.valueOf(path) + filename, String.valueOf(path) + filename.replaceAll(".lzma", ""));
                this.subtaskMessage = "Extracting: " + filename.replaceAll(".lzma", "") + " to " + filename.replaceAll(".pack.lzma", "");
                this.extractPack(String.valueOf(path) + filename.replaceAll(".lzma", ""), String.valueOf(path) + filename.replaceAll(".pack.lzma", ""));
            } else if (filename.endsWith(".pack")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".pack", "");
                this.extractPack(String.valueOf(path) + filename, String.valueOf(path) + filename.replace(".pack", ""));
            } else if (filename.endsWith(".lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".lzma", "");
                this.extractLZMA(String.valueOf(path) + filename, String.valueOf(path) + filename.replace(".lzma", ""));
            }
            ++i;
        }
    }

    protected void extractNatives(String path) throws Exception {
        JarEntry entry;
        File nativeFolder;
        this.state = 5;
        int initialPercentage = this.percentage;
        String nativeJar = this.getJarName(this.urlList[this.urlList.length - 1]);
        Certificate[] certificate = Launcher.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certificate == null) {
            URL location = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
            JarURLConnection jurl = (JarURLConnection)new URL("jar:" + location.toString() + "!/net/minecraft/Launcher.class").openConnection();
            jurl.setDefaultUseCaches(true);
            try {
                certificate = jurl.getCertificates();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(nativeFolder = new File(String.valueOf(path) + "natives")).exists()) {
            nativeFolder.mkdir();
        }
        JarFile jarFile = new JarFile(String.valueOf(path) + nativeJar, true);
        Enumeration<JarEntry> entities = jarFile.entries();
        this.totalSizeExtract = 0;
        while (entities.hasMoreElements()) {
            entry = entities.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf(47) != -1) continue;
            this.totalSizeExtract = (int)((long)this.totalSizeExtract + entry.getSize());
        }
        this.currentSizeExtract = 0;
        entities = jarFile.entries();
        while (entities.hasMoreElements()) {
            int bufferSize;
            File f;
            entry = entities.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf(47) != -1 || (f = new File(String.valueOf(path) + "natives" + File.separator + entry.getName())).exists() && !f.delete()) continue;
            InputStream in = jarFile.getInputStream(jarFile.getEntry(entry.getName()));
            FileOutputStream out = new FileOutputStream(String.valueOf(path) + "natives" + File.separator + entry.getName());
            byte[] buffer = new byte[65536];
            while ((bufferSize = in.read(buffer, 0, buffer.length)) != -1) {
                ((OutputStream)out).write(buffer, 0, bufferSize);
                this.currentSizeExtract += bufferSize;
                this.percentage = initialPercentage + this.currentSizeExtract * 20 / this.totalSizeExtract;
                this.subtaskMessage = "Extracting: " + entry.getName() + " " + this.currentSizeExtract * 100 / this.totalSizeExtract + "%";
            }
            GameUpdater.validateCertificateChain(certificate, entry.getCertificates());
            in.close();
            ((OutputStream)out).close();
        }
        this.subtaskMessage = "";
        jarFile.close();
        File f = new File(String.valueOf(path) + nativeJar);
        f.delete();
    }

    protected static void validateCertificateChain(Certificate[] ownCerts, Certificate[] native_certs) throws Exception {
        if (ownCerts == null) {
            return;
        }
        if (native_certs == null) {
            throw new Exception("Unable to validate certificate chain. Native entry did not have a certificate chain at all");
        }
        if (ownCerts.length != native_certs.length) {
            throw new Exception("Unable to validate certificate chain. Chain differs in length [" + ownCerts.length + " vs " + native_certs.length + "]");
        }
        int i = 0;
        while (i < ownCerts.length) {
            if (!ownCerts[i].equals(native_certs[i])) {
                throw new Exception("Certificate mismatch: " + ownCerts[i] + " != " + native_certs[i]);
            }
            ++i;
        }
    }

    protected String getJarName(URL url) {
        String fileName = url.getFile();
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        if (fileName.endsWith(".pack.lzma")) {
            fileName = fileName.replaceAll(".pack.lzma", "");
        } else if (fileName.endsWith(".pack")) {
            fileName = fileName.replaceAll(".pack", "");
        } else if (fileName.endsWith(".lzma")) {
            fileName = fileName.replaceAll(".lzma", "");
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected String getFileName(URL url) {
        String fileName = url.getFile();
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected void fatalErrorOccured(String error, Exception e) {
        e.printStackTrace();
        this.fatalError = true;
        this.fatalErrorDescription = "Fatal error occured (" + this.state + "): " + error;
        System.out.println(this.fatalErrorDescription);
        if (e != null) {
            System.out.println(this.generateStacktrace(e));
        }
    }

    public boolean canPlayOffline() {
        String version;
        File dir;
        block5: {
            block4: {
                try {
                    String path = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return Util.getWorkingDirectory() + File.separator + "bin" + File.separator;
                        }
                    });
                    dir = new File(path);
                    if (dir.exists()) break block4;
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            dir = new File(dir, "version");
            if (dir.exists()) break block5;
            return false;
        }
        return dir.exists() && (version = this.readVersionFile(dir)) != null && version.length() > 0;
    }
}

