/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

final class JarVerifier {
    private JarFile jarFile = null;

    JarVerifier(File file) throws IOException {
        this.jarFile = new JarFile(file);
    }

    public void verify(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Manifest manifest = this.jarFile.getManifest();
        if (manifest == null) {
            throw new SecurityException("The provider is not signed");
        }
        byte[] byArray = new byte[8192];
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (((ZipEntry)object2).isDirectory()) continue;
            vector.addElement(object2);
            object = this.jarFile.getInputStream((ZipEntry)object2);
            while (((InputStream)object).read(byArray, 0, byArray.length) != -1) {
            }
            ((InputStream)object).close();
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            X509Certificate[] x509CertificateArray;
            object = (JarEntry)object2.nextElement();
            Certificate[] certificateArray = ((JarEntry)object).getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                if (((ZipEntry)object).getName().startsWith("META-INF")) continue;
                throw new SecurityException("The provider has unsigned class files.");
            }
            int n = 0;
            boolean bl = false;
            while ((x509CertificateArray = JarVerifier.getAChain(certificateArray, n)) != null) {
                if (x509CertificateArray[0].equals(x509Certificate)) {
                    bl = true;
                    break;
                }
                n += x509CertificateArray.length;
            }
            if (bl) continue;
            throw new SecurityException("The provider is not signed by a trusted signer");
        }
    }

    private static X509Certificate[] getAChain(Certificate[] certificateArray, int n) {
        int n2;
        if (n > certificateArray.length - 1) {
            return null;
        }
        for (n2 = n; n2 < certificateArray.length - 1 && ((Object)((X509Certificate)certificateArray[n2 + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        int n3 = n2 - n + 1;
        X509Certificate[] x509CertificateArray = new X509Certificate[n3];
        for (int i = 0; i < n3; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[n + i];
        }
        return x509CertificateArray;
    }

    protected void finalize() throws Throwable {
        this.jarFile.close();
    }
}

