/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import net.minecraft.launcher.JarVerifier;

public class MinecraftLauncher
extends Applet
implements Runnable {
    private static final int linux = 0;
    private static final int solaris = 1;
    private static final int windows = 2;
    private static final int macos = 3;
    private static final int unknown = 4;
    private static final int RESULT_NONE = -1;
    private static final int RESULT_OK = 0;
    private static final int RESULT_END = 1;
    private static final int RESULT_EXCEPTION = 2;
    private int[] memorySizes = new int[]{1024, 900, 600};
    private String[] javaExecutables = new String[]{"javaw", "java"};
    private String[] paths = new String[]{"", ""};
    private static final long serialVersionUID = 1L;
    private Label label;
    private TextArea text;
    private static File workDir = null;
    private boolean started = false;
    private volatile int result = -1;
    private volatile Throwable exception;

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = MinecraftLauncher.getWorkingDirectory("minecraft");
        }
        return workDir;
    }

    public static File getWorkingDirectory(String string) {
        File file;
        String string2 = System.getProperty("user.home", ".");
        switch (MinecraftLauncher.getPlatform()) {
            case 0: 
            case 1: {
                file = new File(string2, '.' + string + '/');
                break;
            }
            case 2: {
                String string3 = System.getenv("APPDATA");
                if (string3 != null) {
                    file = new File(string3, "." + string + '/');
                    break;
                }
                file = new File(string2, '.' + string + '/');
                break;
            }
            case 3: {
                file = new File(string2, "Library/Application Support/" + string);
                break;
            }
            default: {
                file = new File(string2, string + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static int getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("win")) {
            return 2;
        }
        if (string.contains("mac")) {
            return 3;
        }
        if (string.contains("solaris")) {
            return 1;
        }
        if (string.contains("sunos")) {
            return 1;
        }
        if (string.contains("linux")) {
            return 0;
        }
        if (string.contains("unix")) {
            return 0;
        }
        return 4;
    }

    private byte[] read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptStart(String string, String string2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add("-Xmx" + n + "m");
        arrayList.add("-Xms" + n + "m");
        arrayList.add("-cp");
        arrayList.add(string2);
        arrayList.add("-Dsun.java2d.noddraw=true");
        arrayList.add("-Dsun.java2d.d3d=false");
        arrayList.add("-Dsun.java2d.opengl=false");
        arrayList.add("-Dsun.java2d.pmoffscreen=false");
        arrayList.add("net.minecraft.LauncherFrame");
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        this.log("Trying \"" + string + "\" with " + n + "MB ram");
        processBuilder.redirectErrorStream(true);
        this.result = -1;
        Process process = null;
        try {
            process = processBuilder.start();
            OutputStream outputStream = process.getOutputStream();
            this.pipe(process.getInputStream(), System.out);
            for (int i = 0; this.result == -1 && i < 5000; i += 10) {
                Thread.sleep(10L);
            }
        }
        catch (Exception exception) {
            this.result = 2;
            this.exception = exception;
            exception.printStackTrace();
        }
        finally {
            if (this.result != 0 && process != null) {
                process.destroy();
            }
        }
        if (this.result == 2) {
            this.log("Failed to launch: " + this.exception.toString());
        } else if (this.result == -1) {
            this.log("Failed to launch: timeout");
        } else if (this.result == 1) {
            this.log("Failed to launch: end of stream");
        }
    }

    public void startSecondJVM(File file) throws Exception {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        this.paths[1] = System.getProperty("java.home") + string2 + "bin" + string2;
        for (int i = 0; i < this.paths.length; ++i) {
            for (int j = 0; j < this.javaExecutables.length; ++j) {
                for (int k = 0; k < this.memorySizes.length; ++k) {
                    int n = this.memorySizes[k];
                    String string3 = this.paths[i] + this.javaExecutables[j];
                    this.attemptStart(string3, string, n);
                    if (this.result != 0) continue;
                    return;
                }
            }
        }
    }

    private void pipe(final InputStream inputStream, PrintStream printStream) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string = "";
                    while ((string = bufferedReader.readLine()) != null) {
                        System.out.println(string);
                        if (!string.equals("launchVerified")) continue;
                        MinecraftLauncher.this.result = 0;
                    }
                    MinecraftLauncher.this.result = 1;
                }
                catch (Throwable throwable) {
                    MinecraftLauncher.this.result = 2;
                    MinecraftLauncher.this.exception = throwable;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.text = new TextArea();
        this.text.setEditable(false);
        this.text.setFont(new Font("monospaced", 0, 12));
        this.log("Minecraft Launcher Loader 3.0");
        this.log("-----------------------------");
        this.log("");
        this.log("Running tests..");
        this.log("");
        this.add((Component)this.text, "Center");
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMd5Hash(File file) throws IOException, NoSuchAlgorithmException {
        byte[] byArray;
        if (!file.exists()) {
            return null;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        InputStream inputStream = new FileInputStream(file);
        try {
            inputStream = new DigestInputStream(inputStream, messageDigest);
            byArray = new byte[1024];
            int n = 0;
            while (n != -1) {
                n = inputStream.read(byArray);
            }
        }
        finally {
            inputStream.close();
        }
        byArray = messageDigest.digest();
        return new BigInteger(1, byArray).toString(16);
    }

    private void download(String string, File file, String string2) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        if (string2 != null) {
            this.log("Local hash: " + string2);
            httpURLConnection.setRequestProperty("If-None-Match", string2);
        }
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() == 304) {
            this.log("Local file not modified");
            return;
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        ((OutputStream)fileOutputStream).close();
        inputStream.close();
    }

    private void verify(File file) throws MalformedURLException, IOException, CertificateException {
        new JarVerifier(file).verify(this.setupProviderCert());
    }

    private X509Certificate setupProviderCert() throws IOException, CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.read(MinecraftLauncher.class.getResourceAsStream("/mojang.cert")));
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        byteArrayInputStream.close();
        return x509Certificate;
    }

    public void run() {
        try {
            this.log("Finding minecraft launcher file..");
            File file = new File(MinecraftLauncher.getWorkingDirectory(), "launcher");
            file.mkdirs();
            File file2 = new File(file, "launcher.jar");
            this.log(file2.toString());
            String string = "http://launch.minecraft.net/mclauncher.jar";
            this.log("Downloading mclaunchtest.jar..");
            try {
                this.download(string, file2, this.getMd5Hash(file2));
            }
            catch (Exception exception) {
                this.log("Failed to download file: " + exception);
                if (file2.exists()) {
                    this.log("Local file exists, ignore error");
                }
                throw exception;
            }
            this.log("Downloaded size: " + file2.length());
            this.log("Verifying file..");
            this.verify(file2);
            this.log("Launching JVM..");
            this.startSecondJVM(file2);
            this.log("");
            if (this.result == 0) {
                this.log("Verified! All is well!");
            } else {
                this.log("Failed! The new window never appeared");
            }
        }
        catch (Exception exception) {
            this.log("");
            this.log("FAIL: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private void log(String string) {
        this.text.append(string + "\n");
        this.text.setCaretPosition(this.text.getText().length() - 1);
    }
}

