/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter;

import SevenZip.Compression.LZMA.Decoder;
import info.mineshafter.Util;
import info.mineshafter.proxy.ModularProxy;
import info.mineshafter.proxy.SocksProxyConnection;
import info.mineshafter.proxy.YggdrasilProxyHandler;
import info.mineshafter.util.Resources;
import info.mineshafter.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Bootstrap
extends JFrame {
    public static Thread mainThread;
    private static final long serialVersionUID = 1L;
    private static int bootstrapVersion;
    private static int mineshafterBootstrapVersion;
    private final File workDir = Util.getWorkingDirectory();
    private final File launcherJar = new File(this.workDir, "launcher.jar");
    private final File packedLauncherJar = new File(this.workDir, "launcher.pack.lzma");
    private final File packedLauncherJarNew = new File(this.workDir, "launcher.pack.lzma.new");
    private final File patchedLauncherJar = new File(this.workDir, "launcher_mcpatched.jar");

    static {
        bootstrapVersion = 4;
        mineshafterBootstrapVersion = 6;
    }

    public Bootstrap() {
        super("Minecraft Launcher");
    }

    public void run() {
        if (!this.workDir.isDirectory()) {
            this.workDir.mkdir();
        }
        if (this.packedLauncherJarNew.isFile()) {
            this.renameNew();
        }
        String md5 = null;
        if (this.packedLauncherJar.exists()) {
            md5 = Util.getMd5(this.packedLauncherJar);
        }
        if (!Util.grabLauncher(md5, this.packedLauncherJarNew)) {
            System.out.println("New launcher not downloaded");
        }
        this.renameNew();
        this.unpack();
        this.patchLauncher();
        this.startLauncher();
    }

    public void renameNew() {
        if (this.packedLauncherJarNew.isFile()) {
            this.packedLauncherJar.delete();
            this.packedLauncherJarNew.renameTo(this.packedLauncherJar);
        }
    }

    public void unpack() {
        if (!this.packedLauncherJar.exists()) {
            return;
        }
        String path = this.packedLauncherJar.getAbsolutePath();
        File unpacked = new File(path.substring(0, path.lastIndexOf(46)));
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(this.packedLauncherJar));
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(unpacked));
            byte[] properties = new byte[5];
            inStream.read(properties, 0, 5);
            Decoder decoder = new Decoder();
            decoder.SetDecoderProperties(properties);
            long outSize = 0L;
            int i = 0;
            while (i < 8) {
                int v = inStream.read();
                outSize |= (long)v << 8 * i;
                ++i;
            }
            decoder.Code(inStream, outStream, outSize);
            inStream.close();
            outStream.flush();
            outStream.close();
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.launcherJar));
            Pack200.newUnpacker().unpack(unpacked, jarOut);
            jarOut.close();
            unpacked.delete();
        }
        catch (IOException e) {
            System.out.println("Exception while unpacking:");
            e.printStackTrace();
        }
    }

    public void patchLauncher() {
        if (!this.launcherJar.exists()) {
            return;
        }
        if (this.patchedLauncherJar.exists()) {
            this.patchedLauncherJar.delete();
        }
        try {
            ZipEntry entry;
            ZipInputStream inStream = new ZipInputStream(new FileInputStream(this.launcherJar));
            ZipOutputStream outStream = new ZipOutputStream(new FileOutputStream(this.patchedLauncherJar));
            while ((entry = inStream.getNextEntry()) != null) {
                String n = entry.getName();
                if (n.startsWith("META-INF/") && (n.endsWith(".DSA") || n.endsWith(".RSA") || n.endsWith(".SF"))) continue;
                outStream.putNextEntry(entry);
                InputStream dataSource = n.equals("META-INF/MANIFEST.MF") ? new ByteArrayInputStream("Manifest-Version: 1.0\n".getBytes()) : (n.equals("com/mojang/authlib/HttpAuthenticationService.class") ? Resources.load("resources/HttpAuthenticationService.class") : inStream);
                Streams.pipeStreams(dataSource, outStream);
                outStream.flush();
            }
            inStream.close();
            outStream.close();
        }
        catch (Exception e) {
            System.out.println("Error while patching launcher:");
            e.printStackTrace();
        }
    }

    public void startLauncher() {
        ModularProxy proxy = new ModularProxy(SocksProxyConnection.class, new YggdrasilProxyHandler());
        proxy.start();
        int proxyPort = proxy.getListeningPort();
        System.setErr(System.out);
        System.setProperty("java.net.preferIPv4Stack", "true");
        Proxy proxyInfo = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", proxyPort));
        try {
            Class<?> launcher = new URLClassLoader(new URL[]{this.patchedLauncherJar.toURI().toURL()}).loadClass("net.minecraft.launcher.Launcher");
            Constructor<?> ctor = launcher.getConstructor(JFrame.class, File.class, Proxy.class, PasswordAuthentication.class, String[].class, Integer.class);
            Object[] objectArray = new Object[6];
            objectArray[0] = this;
            objectArray[1] = this.workDir;
            objectArray[2] = proxyInfo;
            objectArray[4] = new String[0];
            objectArray[5] = bootstrapVersion;
            ctor.newInstance(objectArray);
        }
        catch (Exception e) {
            System.out.println("Error while starting launcher:");
            e.printStackTrace();
        }
        this.setSize(854, 480);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        mainThread = Thread.currentThread();
        float v = Util.getCurrentBootstrapVersion();
        System.out.println("Current proxy version: " + mineshafterBootstrapVersion);
        System.out.println("Gotten proxy version: " + v);
        if ((float)mineshafterBootstrapVersion < v) {
            JOptionPane.showMessageDialog(null, "A new version of Mineshafter is available at http://mineshafter.info/\nGo get it.", "Update Available", -1);
            System.exit(0);
        }
        Bootstrap frame = new Bootstrap();
        frame.run();
    }
}

