/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter.proxy;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

class UDPRelayServer {
    DatagramSocket client_sock = new DatagramSocket(0, InetAddress.getLoopbackAddress());
    DatagramSocket remote_sock;
    int relayPort = this.client_sock.getLocalPort();
    InetAddress relayIP = this.client_sock.getLocalAddress();
    Thread pipe_thread1;
    Thread pipe_thread2;
    Thread master_thread;
    static int datagramSize = 65535;
    static int idleTimeout = 30000;

    public UDPRelayServer(InetAddress clientIP, int clientPort) throws IOException {
        this.remote_sock = new DatagramSocket();
    }

    public static void setTimeout(int timeout) {
        idleTimeout = timeout;
    }

    public static void setDatagramSize(int size) {
        datagramSize = size;
    }

    public int getRelayPort() {
        return this.relayPort;
    }

    public InetAddress getRelayIP() {
        return this.relayIP;
    }

    public void start() throws IOException {
        this.pipeActive(this.client_sock, this.remote_sock);
        this.pipeActive(this.remote_sock, this.client_sock);
    }

    public synchronized void stop() {
        this.remote_sock.close();
        this.client_sock.close();
    }

    private void pipe(DatagramSocket from, DatagramSocket to) {
        byte[] data = new byte[datagramSize];
        DatagramPacket dp = new DatagramPacket(data, data.length);
        try {
            from.setSoTimeout(idleTimeout);
            while (true) {
                from.receive(dp);
                to.send(dp);
                dp.setLength(data.length);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void pipeActive(final DatagramSocket from, final DatagramSocket to) {
        Thread t = new Thread("Datagram pipe thread"){

            public void run() {
                UDPRelayServer.this.pipe(from, to);
            }
        };
        t.start();
    }
}

