/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter.proxy;

import com.google.gson.Gson;
import info.mineshafter.Util;
import info.mineshafter.proxy.YggdrasilRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class YggdrasilImpersonator {
    private List<Profile> profiles = Collections.synchronizedList(new ArrayList());
    private Gson gson = new Gson();

    public YggdrasilImpersonator(File profilesFile) {
        try {
            ProfilesJSON profiles = this.gson.fromJson((Reader)new FileReader(profilesFile), ProfilesJSON.class);
            Map<String, Profile> ps = profiles.authenticationDatabase;
            for (String name : ps.keySet()) {
                Profile p = ps.get(name);
                if (p == null) continue;
                if (p.displayName == null || p.displayName.length() == 0) {
                    p.displayName = p.username;
                }
                this.profiles.add(p);
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (NullPointerException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getProfileByUsername(String name) {
        List<Profile> list = this.profiles;
        synchronized (list) {
            for (Profile p : this.profiles) {
                if (!p.username.equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getProfileByAccessToken(String token) {
        List<Profile> list = this.profiles;
        synchronized (list) {
            for (Profile p : this.profiles) {
                if (!p.accessToken.equals(token)) continue;
                return p;
            }
        }
        return null;
    }

    public String authenticate(YggdrasilRequest req) {
        String accessToken = Util.getMd5(String.valueOf(req.username) + req.password + Long.toString(System.currentTimeMillis()));
        Profile p = this.getProfileByUsername(req.username);
        if (p == null) {
            String id = Util.getMd5(req.username);
            p = new Profile(req.username, accessToken, id, req.username);
            this.profiles.add(p);
        }
        p.accessToken = accessToken;
        ProfileResponse pr = new ProfileResponse(p.uuid, p.displayName);
        YggdrasilAuthResponse r = new YggdrasilAuthResponse(req.clientToken, p.accessToken, pr, pr);
        return this.gson.toJson(r);
    }

    public String refresh(YggdrasilRequest req) {
        String newAccessToken;
        Profile p = this.getProfileByAccessToken(req.accessToken);
        if (p == null) {
            return "{\"error\":\"ForbiddenOperationException\",\"errorMessage\":\"Invalid token.\"}";
        }
        p.accessToken = newAccessToken = Util.getMd5(String.valueOf(req.accessToken) + Long.toString(System.currentTimeMillis()));
        YggdrasilAuthResponse r = new YggdrasilAuthResponse(req.clientToken, newAccessToken, new ProfileResponse(p.uuid, p.displayName), null);
        return this.gson.toJson(r);
    }

    public String invalidate(YggdrasilRequest req) {
        Profile p = this.getProfileByAccessToken(req.accessToken);
        p.accessToken = null;
        return "";
    }

    public class Profile {
        public String username;
        public String accessToken;
        public String uuid;
        public String displayName;
        public String name;
        public String playerUUID;

        public Profile(String u, String t, String id, String d) {
            this.username = u;
            this.accessToken = t;
            this.uuid = id;
            this.displayName = d;
        }
    }

    public class ProfileResponse {
        public String id;
        public String name;

        public ProfileResponse(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public class ProfilesJSON {
        public Map<String, Profile> profiles;
        public String selectedProfile;
        public String clientToken;
        public Map<String, Profile> authenticationDatabase;
    }

    public class YggdrasilAuthResponse {
        public String accessToken;
        public String clientToken;
        public ProfileResponse selectedProfile;
        public ArrayList<ProfileResponse> availableProfiles;

        public YggdrasilAuthResponse(String clientToken, String accessToken, ProfileResponse selected, ProfileResponse available) {
            this.clientToken = clientToken;
            this.accessToken = accessToken;
            this.selectedProfile = selected;
            if (available != null) {
                this.availableProfiles = new ArrayList();
                this.availableProfiles.add(available);
            } else {
                this.availableProfiles = null;
            }
        }
    }
}

