/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter.proxy;

import com.google.gson.Gson;
import info.mineshafter.Util;
import info.mineshafter.proxy.HttpProxyHandler;
import info.mineshafter.proxy.SocksMessage;
import info.mineshafter.proxy.SocksProxyHandler;
import info.mineshafter.proxy.YggdrasilImpersonator;
import info.mineshafter.proxy.YggdrasilRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YggdrasilProxyHandler
implements HttpProxyHandler,
SocksProxyHandler {
    public static String authServer = "mineshafter.info";
    public static Pattern SKIN_URL = Pattern.compile("http://skins\\.minecraft\\.net/MinecraftSkins/(.+?)\\.png");
    public static Pattern CLOAK_URL = Pattern.compile("http://skins\\.minecraft\\.net/MinecraftCloaks/(.+?)\\.png");
    public static Pattern AUTHSERVER_URL = Pattern.compile("http://authserver\\.mojang\\.com/(.*)");
    private Map<String, byte[]> skinCache = new Hashtable<String, byte[]>();
    private Map<String, byte[]> cloakCache = new Hashtable<String, byte[]>();
    private YggdrasilImpersonator imp = new YggdrasilImpersonator(new File(Util.getWorkingDirectory(), "launcher_profiles.json"));

    @Override
    public boolean onConnect(InputStream in, OutputStream out, SocksMessage msg) {
        String header;
        in.mark(65535);
        String firstLine = YggdrasilProxyHandler.readUntil(in, '\n');
        String[] request = firstLine.split(" ");
        if (request.length != 3) {
            System.out.println("Not an HTTP request: " + firstLine);
            try {
                in.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        String method = request[0].toUpperCase();
        String path = request[1];
        HashMap<String, String> headers = new HashMap<String, String>();
        do {
            header = YggdrasilProxyHandler.readUntil(in, '\n');
            int splitPoint = (header = header.trim()).indexOf(58);
            if (splitPoint == -1) continue;
            headers.put(header.substring(0, splitPoint).toLowerCase().trim(), header.substring(splitPoint + 1).trim());
        } while (header.length() > 0);
        String url = "http://" + (String)headers.get("host") + path;
        System.out.println("Proxy - onConnect - url: " + url);
        if (method.equals("GET") ? this.onGET(url, headers, in, out) : (method.equals("POST") ? this.onPOST(url, headers, in, out) : method.equals("HEAD") && this.onHEAD(url, headers, in, out))) {
            return true;
        }
        try {
            in.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean onBind() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onGET(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        System.out.println("Proxy - onGET: " + url);
        Matcher skinMatcher = SKIN_URL.matcher(url);
        Matcher cloakMatcher = CLOAK_URL.matcher(url);
        byte[] data = null;
        if (skinMatcher.matches()) {
            System.out.println("Proxy: Skin");
            String username = skinMatcher.group(1);
            if (this.skinCache.containsKey(username)) {
                data = this.skinCache.get(username);
                return false;
            }
            url = "http://" + authServer + "/mcapi/skin/" + username + ".png";
            System.out.println("To: " + url);
            data = YggdrasilProxyHandler.getRequest(url);
            System.out.println("Response length: " + data.length);
            this.skinCache.put(username, data);
            this.sendResponse(out, "image/png", data);
            return true;
        }
        if (!cloakMatcher.matches()) return false;
        System.out.println("Proxy: Cloak");
        String username = cloakMatcher.group(1);
        if (this.cloakCache.containsKey(username)) {
            data = this.cloakCache.get(username);
            return false;
        }
        url = "http://" + authServer + "/mcapi/cloak/" + username + ".png";
        System.out.println("To: " + url);
        data = YggdrasilProxyHandler.getRequest(url);
        System.out.println("Response length: " + data.length);
        this.cloakCache.put(username, data);
        this.sendResponse(out, "image/png", data);
        return true;
    }

    @Override
    public boolean onPOST(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        int contentLength = Integer.parseInt(headers.get("content-length"));
        Matcher authServerMatcher = AUTHSERVER_URL.matcher(url);
        if (authServerMatcher.matches()) {
            System.out.println("Proxy: Authserver");
            String endpoint = authServerMatcher.group(1);
            try {
                char[] body = new char[contentLength];
                InputStreamReader reader = new InputStreamReader(in);
                reader.read(body);
                String postedJSON = new String(body);
                String response = this.authServerEndpoint(endpoint, postedJSON);
                this.sendResponse(out, "application/json", response);
            }
            catch (IOException e) {
                System.out.println("Unable to read POST data from getversion request");
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onHEAD(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        return false;
    }

    @Override
    public boolean onCONNECT(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        return false;
    }

    private void sendResponse(OutputStream out, String contentType, String data) {
        this.sendResponse(out, contentType, data.getBytes());
    }

    private void sendResponse(OutputStream out, String contentType, byte[] data) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.append("HTTP/1.0 200 OK\r\nConnection: close\r\nProxy-Connection: close\r\n");
            writer.append("Content-Length: " + Integer.toString(data.length) + "\r\n");
            if (contentType != null) {
                writer.append("Content-Type: " + contentType + "\r\n\r\n");
            }
            writer.flush();
            out.write(data);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Proxy - sendResponse error:");
            e.printStackTrace();
        }
    }

    private String authServerEndpoint(String endpoint, String postedJSON) {
        Gson gson = new Gson();
        YggdrasilRequest data = gson.fromJson(postedJSON, YggdrasilRequest.class);
        System.out.println("Proxy postedJSON: " + postedJSON);
        if (endpoint.equalsIgnoreCase("authenticate")) {
            String reply = this.imp.authenticate(data);
            System.out.println("Proxy authenticate response: " + reply);
            return reply;
        }
        if (endpoint.equalsIgnoreCase("refresh")) {
            String reply = this.imp.refresh(data);
            System.out.println("Proxy refresh response: " + reply);
            return reply;
        }
        if (endpoint.equalsIgnoreCase("invalidate")) {
            String reply = this.imp.invalidate(data);
            return reply;
        }
        return "";
    }

    public static byte[] getRequest(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            Map<String, List<String>> requestHeaders = conn.getRequestProperties();
            int code = conn.getResponseCode();
            if (code / 100 == 3) {
                System.out.println("Java didn't redirect automatically, going manual: " + Integer.toString(code));
                String loc = conn.getHeaderField("location").trim();
                System.out.println("Manual redirection to: " + loc);
                return YggdrasilProxyHandler.getRequest(loc);
            }
            System.out.println("Response: " + code);
            if (code == 403) {
                String s = "403 from req to " + url + "\nRequest headers:\n";
                for (String k : requestHeaders.keySet()) {
                    if (k == null) continue;
                    List<String> vals = requestHeaders.get(k);
                    for (String v : vals) {
                        s = String.valueOf(s) + k + ": " + v + "\n";
                    }
                }
                s = String.valueOf(s) + "Response headers:\n";
                Map<String, List<String>> responseHeaders = conn.getHeaderFields();
                for (String k : responseHeaders.keySet()) {
                    if (k == null) continue;
                    List<String> vals = responseHeaders.get(k);
                    for (String v : vals) {
                        s = String.valueOf(s) + k + ": " + v + "\n";
                    }
                }
                System.out.println(s);
                System.out.println("Contents:\n" + new String(YggdrasilProxyHandler.grabData(conn.getErrorStream())));
            }
            if (code / 100 == 4) {
                return new byte[0];
            }
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            return YggdrasilProxyHandler.grabData(in);
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL in getRequest:");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO error during a getRequest:");
            e.printStackTrace();
        }
        return new byte[0];
    }

    public static byte[] postRequest(String url, String postdata, String contentType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.write(postdata);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] rd = YggdrasilProxyHandler.postRequest(url, out.toByteArray(), contentType);
        return rd;
    }

    public static byte[] postRequest(String url, byte[] postdata, String contentType) {
        try {
            URL u = new URL(url);
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
            c.setDoOutput(true);
            c.setRequestMethod("POST");
            c.setRequestProperty("Host", u.getHost());
            c.setRequestProperty("Content-Length", Integer.toString(postdata.length));
            c.setRequestProperty("Content-Type", contentType);
            BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());
            out.write(postdata);
            out.flush();
            out.close();
            byte[] data = YggdrasilProxyHandler.grabData(new BufferedInputStream(c.getInputStream()));
            return data;
        }
        catch (UnknownHostException e) {
            System.out.println("Unable to resolve remote host, returning null");
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL when doing postRequest:");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] grabData(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (true) {
            int len;
            try {
                len = in.read(buffer);
                if (len == -1) {
                }
            }
            catch (IOException e) {}
            break;
            out.write(buffer, 0, len);
        }
        return out.toByteArray();
    }

    public static String readUntil(InputStream is, String endSequence) {
        return YggdrasilProxyHandler.readUntil(is, endSequence.getBytes());
    }

    public static String readUntil(InputStream is, char endSequence) {
        return YggdrasilProxyHandler.readUntil(is, new byte[]{(byte)endSequence});
    }

    public static String readUntil(InputStream is, byte endSequence) {
        return YggdrasilProxyHandler.readUntil(is, new byte[]{endSequence});
    }

    public static String readUntil(InputStream is, byte[] endSequence) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            boolean end;
            int i = 0;
            do {
                byte b;
                end = false;
                try {
                    b = (byte)is.read();
                }
                catch (EOFException e) {
                    break;
                }
                if (b == endSequence[i]) {
                    if (i == endSequence.length - 1) {
                        end = true;
                    }
                    ++i;
                } else {
                    i = 0;
                }
                out.write(b);
            } while (!end);
        }
        catch (IOException e) {
            System.out.println("readUntil unable to read from InputStream, endSeq: " + new String(endSequence));
            e.printStackTrace();
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

