/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Http {
    public static String buildQuery(Map<String, Object> query) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : query.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            try {
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Unexpected exception building query: " + e.toString());
            }
            if (entry.getValue() == null) continue;
            builder.append('=');
            try {
                builder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Unexpected exception building query: " + e.toString());
            }
        }
        return builder.toString();
    }

    public static String performPost(URL url, Map<String, Object> query, Proxy proxy) throws IOException {
        return Http.performPost((URL)url, (String)Http.buildQuery(query), (Proxy)proxy, (String)"application/x-www-form-urlencoded", (boolean)false);
    }

    public static String performPost(URL url, String parameters, Proxy proxy, String contentType, boolean returnErrorPage) throws IOException {
        String line;
        BufferedReader reader;
        if (url.getProtocol().equals("https")) {
            url = new URL("http", url.getHost(), url.getPort(), url.getFile());
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(proxy);
        byte[] paramAsBytes = parameters.getBytes(Charset.forName("UTF-8"));
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", String.valueOf(contentType) + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + paramAsBytes.length);
        connection.setRequestProperty("Content-Language", "en-US");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
        writer.write(paramAsBytes);
        writer.flush();
        writer.close();
        try {
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (IOException e) {
            if (returnErrorPage) {
                InputStream stream = connection.getErrorStream();
                if (stream != null) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                }
                throw e;
            }
            throw e;
        }
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        reader.close();
        return response.toString();
    }

    public static String performGet(URL url, Proxy proxy) throws IOException {
        String line;
        if (url.getProtocol().equals("https")) {
            url = new URL("http", url.getHost(), url.getPort(), url.getFile());
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(proxy);
        connection.setRequestMethod("GET");
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        reader.close();
        return response.toString();
    }

    public static URL concatenateURL(URL url, String args) throws MalformedURLException {
        if (url.getQuery() != null && url.getQuery().length() > 0) {
            return new URL(url.getProtocol(), url.getHost(), String.valueOf(url.getFile()) + "?" + args);
        }
        return new URL(url.getProtocol(), url.getHost(), String.valueOf(url.getFile()) + "&" + args);
    }
}

