/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter.proxy;

import info.mineshafter.proxy.ProxyConnection;
import info.mineshafter.proxy.Socks4Message;
import info.mineshafter.proxy.Socks5Message;
import info.mineshafter.proxy.SocksMessage;
import info.mineshafter.proxy.SocksProxyHandler;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class SocksProxyConnection
implements ProxyConnection {
    static final int TIMEOUT = 30000;
    static final int INPUT_BUFFER_SIZE = 65535;
    private Socket clientSock;
    private BufferedInputStream in;
    private OutputStream out;
    private SocksProxyHandler handler;

    public SocksProxyConnection(Socket s, SocksProxyHandler h) {
        this.clientSock = s;
        this.handler = h;
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        try {
            this.startSession();
            SocksMessage msg = this.readMsg();
            this.handleRequest(msg);
            this.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startSession() {
        try {
            this.clientSock.setSoTimeout(30000);
            BufferedInputStream in = new BufferedInputStream(this.clientSock.getInputStream(), 65535);
            OutputStream out = this.clientSock.getOutputStream();
            in.mark(65535);
            int version = in.read();
            if (version == 5) {
                int num_methods = in.read();
                int bread = 0;
                while (bread < num_methods) {
                    if (in.read() == 0) {
                        byte[] byArray = new byte[2];
                        byArray[0] = 5;
                        out.write(byArray);
                    }
                    ++bread;
                }
            } else if (version == 4) {
                in.reset();
            }
            this.in = in;
            this.out = out;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleRequest(SocksMessage msg) throws Exception {
        if (msg.ip == null) {
            if (msg instanceof Socks5Message) {
                msg.ip = InetAddress.getByName(msg.host);
            } else {
                return;
            }
        }
        switch (msg.command) {
            case 1: {
                this.onConnect(msg);
                break;
            }
            case 2: {
                this.onBind(msg);
                break;
            }
            case 3: {
                throw new Exception("UDP Assoc!!!!!");
            }
        }
    }

    private void onConnect(SocksMessage msg) throws IOException {
        SocksMessage response = null;
        response = msg instanceof Socks5Message ? new Socks5Message(0, InetAddress.getLocalHost(), 0) : new Socks4Message(90, InetAddress.getLocalHost(), 0);
        response.write(this.out);
        if (!this.handler.onConnect(this.in, this.out, msg)) {
            Socket s = new Socket(msg.ip, msg.port);
            this.pipeActive(this.in, s.getOutputStream());
            this.pipe(s.getInputStream(), this.out);
        }
    }

    private void onBind(SocksMessage msg) throws IOException {
        ServerSocket bound = new ServerSocket(0, 5, InetAddress.getLoopbackAddress());
        bound.setSoTimeout(30000);
        SocksMessage response = msg.version == 5 ? new Socks5Message(0, bound.getInetAddress(), bound.getLocalPort()) : new Socks4Message(90, bound.getInetAddress(), bound.getLocalPort());
        response.write(this.out);
        Socket s = null;
        while (true) {
            try {
                s = bound.accept();
            }
            catch (SocketTimeoutException e) {
                s = null;
                bound.close();
                break;
            }
            if (s.getInetAddress().equals(msg.ip)) {
                bound.close();
                break;
            }
            s.close();
        }
        response = msg.version == 5 ? new Socks5Message(s == null ? 1 : 0, s.getInetAddress(), s.getPort()) : new Socks4Message(s == null ? 91 : 90, s.getInetAddress(), s.getPort());
        response.write(this.out);
        if (s != null) {
            this.pipeActive(this.in, s.getOutputStream());
            this.pipe(s.getInputStream(), this.out);
        }
    }

    private SocksMessage readMsg() throws IOException {
        this.in.mark(5);
        int version = this.in.read();
        this.in.reset();
        SocksMessage msg = null;
        if (version == 5) {
            msg = new Socks5Message(this.in);
        } else if (version == 4) {
            msg = new Socks4Message(this.in);
        } else {
            throw new IOException("Invalid SOCKS version: " + version);
        }
        return msg;
    }

    private synchronized void abort() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            this.clientSock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pipe(InputStream in, OutputStream out) {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
                out.flush();
            }
        }
        catch (EOFException e) {
            return;
        }
        catch (SocketException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void pipeActive(final InputStream in, final OutputStream out) {
        Thread t = new Thread("Active piping thread"){

            public void run() {
                SocksProxyConnection.this.pipe(in, out);
            }
        };
        t.start();
    }
}

