/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter.proxy.handlers;

import info.mineshafter.Util;
import info.mineshafter.proxy.HttpProxyHandler;
import info.mineshafter.proxy.SocksMessage;
import info.mineshafter.proxy.SocksProxyHandler;
import info.mineshafter.proxy.handlers.Handler;
import info.mineshafter.proxy.handlers.Profiles;
import info.mineshafter.proxy.handlers.SkinHandler;
import info.mineshafter.proxy.handlers.YggdrasilImpersonator;
import info.mineshafter.util.Http;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YggdrasilProxyHandler
implements HttpProxyHandler,
SocksProxyHandler {
    public static String authServer = "mineshafter.info";
    private Map<Pattern, Handler> handlers = new HashMap<Pattern, Handler>();

    public YggdrasilProxyHandler() {
        SkinHandler sh = new SkinHandler();
        this.handlers.put(SkinHandler.SKIN_URL, sh);
        this.handlers.put(SkinHandler.CLOAK_URL, sh);
        YggdrasilImpersonator imp = new YggdrasilImpersonator(new File(Util.getWorkingDirectory(), "launcher_profiles.json"));
        this.handlers.put(YggdrasilImpersonator.AUTHSERVER_URL, imp);
        Profiles p = new Profiles();
        this.handlers.put(Profiles.PROFILE_BY_ID, p);
        this.handlers.put(Profiles.PROFILE_BY_NAME, p);
    }

    @Override
    public boolean onConnect(InputStream in, OutputStream out, SocksMessage msg) {
        String header;
        in.mark(65535);
        String firstLine = Http.readUntil(in, '\n');
        String[] request = firstLine.split(" ");
        if (request.length != 3) {
            System.out.println("Not an HTTP request: " + firstLine);
            try {
                in.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        String method = request[0].toUpperCase();
        String path = request[1];
        HashMap<String, String> headers = new HashMap<String, String>();
        do {
            header = Http.readUntil(in, '\n');
            int splitPoint = (header = header.trim()).indexOf(58);
            if (splitPoint == -1) continue;
            headers.put(header.substring(0, splitPoint).toLowerCase().trim(), header.substring(splitPoint + 1).trim());
        } while (header.length() > 0);
        String url = "http://" + (String)headers.get("host") + path;
        System.out.println("Proxy - onConnect - " + method + " " + url);
        byte[] body = null;
        if (method.equalsIgnoreCase("POST")) {
            int contentLength = Integer.parseInt((String)headers.get("content-length"));
            String b = Http.readUntil(in, contentLength);
            body = b.getBytes();
        }
        boolean r = this.handler(url, headers, body, out);
        try {
            in.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return r;
    }

    public boolean handler(String url, Map<String, String> headers, byte[] body, OutputStream res) {
        for (Pattern p : this.handlers.keySet()) {
            Matcher m = p.matcher(url);
            if (!m.matches()) continue;
            Handler h = this.handlers.get(p);
            h.handle(url, headers, body, res);
            return true;
        }
        return false;
    }

    @Override
    public boolean onGET(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        System.out.println("Proxy: GET " + url);
        return this.handler(url, headers, null, out);
    }

    @Override
    public boolean onPOST(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        System.out.println("Proxy: POST " + url);
        int contentLength = Integer.parseInt(headers.get("content-length"));
        String b = Http.readUntil(in, contentLength);
        byte[] body = b.getBytes();
        return this.handler(url, headers, body, out);
    }

    @Override
    public boolean onHEAD(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        System.out.println("Proxy: HEAD " + url);
        return false;
    }

    @Override
    public boolean onCONNECT(String url, Map<String, String> headers, InputStream in, OutputStream out) {
        System.out.println("Proxy: CONNECT " + url);
        return false;
    }

    @Override
    public boolean onBind() {
        return false;
    }

    class ProfileRequest {
        String name;
        String agent;

        public ProfileRequest(String name) {
            this.name = name;
            this.agent = "Minecraft";
        }
    }
}

