/*
 * Decompiled with CFR 0.152.
 */
package info.mineshafter.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public class Http {
    public static byte[] getRequest(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            Map<String, List<String>> requestHeaders = conn.getRequestProperties();
            int code = conn.getResponseCode();
            if (code / 100 == 3) {
                System.out.println("Java didn't redirect automatically, going manual: " + Integer.toString(code));
                String loc = conn.getHeaderField("location").trim();
                System.out.println("Manual redirection to: " + loc);
                return Http.getRequest(loc);
            }
            System.out.println("Response: " + code);
            if (code == 403) {
                String s = "403 from req to " + url + "\nRequest headers:\n";
                for (String k : requestHeaders.keySet()) {
                    if (k == null) continue;
                    List<String> vals = requestHeaders.get(k);
                    for (String v : vals) {
                        s = String.valueOf(s) + k + ": " + v + "\n";
                    }
                }
                s = String.valueOf(s) + "Response headers:\n";
                Map<String, List<String>> responseHeaders = conn.getHeaderFields();
                for (String k : responseHeaders.keySet()) {
                    if (k == null) continue;
                    List<String> vals = responseHeaders.get(k);
                    for (String v : vals) {
                        s = String.valueOf(s) + k + ": " + v + "\n";
                    }
                }
                System.out.println(s);
                System.out.println("Contents:\n" + new String(Http.grabData(conn.getErrorStream())));
            }
            if (code / 100 == 4) {
                return new byte[0];
            }
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            return Http.grabData(in);
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL in getRequest:");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO error during a getRequest:");
            e.printStackTrace();
        }
        return new byte[0];
    }

    public static byte[] postRequest(String url, String postdata, String contentType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.write(postdata);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] rd = Http.postRequest(url, out.toByteArray(), contentType);
        return rd;
    }

    public static byte[] postRequest(String url, byte[] postdata, String contentType) {
        try {
            URL u = new URL(url);
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
            c.setDoOutput(true);
            c.setRequestMethod("POST");
            c.setRequestProperty("Host", u.getHost());
            c.setRequestProperty("Content-Length", Integer.toString(postdata.length));
            c.setRequestProperty("Content-Type", contentType);
            BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());
            out.write(postdata);
            out.flush();
            out.close();
            byte[] data = Http.grabData(new BufferedInputStream(c.getInputStream()));
            return data;
        }
        catch (UnknownHostException e) {
            System.out.println("Unable to resolve remote host, returning null");
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL when doing postRequest:");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] grabData(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (true) {
            int len;
            try {
                len = in.read(buffer);
                if (len == -1) {
                }
            }
            catch (IOException e) {}
            break;
            out.write(buffer, 0, len);
        }
        return out.toByteArray();
    }

    public static void sendResponse(OutputStream out, String contentType, String data) {
        Http.sendResponse(out, contentType, data.getBytes());
    }

    public static void sendResponse(OutputStream out, String contentType, byte[] data) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.append("HTTP/1.0 200 OK\r\nConnection: close\r\nProxy-Connection: close\r\n");
            writer.append("Content-Length: " + Integer.toString(data.length) + "\r\n");
            if (contentType != null) {
                writer.append("Content-Type: " + contentType + "\r\n\r\n");
            }
            writer.flush();
            out.write(data);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Proxy - sendResponse error:");
            e.printStackTrace();
        }
    }

    public static String readUntil(InputStream is, String endSequence) {
        return Http.readUntil(is, endSequence.getBytes());
    }

    public static String readUntil(InputStream is, char endSequence) {
        return Http.readUntil(is, new byte[]{(byte)endSequence});
    }

    public static String readUntil(InputStream is, byte endSequence) {
        return Http.readUntil(is, new byte[]{endSequence});
    }

    public static String readUntil(InputStream is, byte[] endSequence) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            boolean end;
            int i = 0;
            do {
                byte b;
                end = false;
                try {
                    b = (byte)is.read();
                }
                catch (EOFException e) {
                    break;
                }
                if (b == endSequence[i]) {
                    if (i == endSequence.length - 1) {
                        end = true;
                    }
                    ++i;
                } else {
                    i = 0;
                }
                out.write(b);
            } while (!end);
        }
        catch (IOException e) {
            System.out.println("readUntil unable to read from InputStream, endSeq: " + new String(endSequence));
            e.printStackTrace();
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String readUntil(InputStream is, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < length) {
                try {
                    byte b = (byte)is.read();
                    out.write(b);
                }
                catch (EOFException e) {
                    break;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

