/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.awt.GridBagConstraints;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.sidebar.SidebarGridForm;
import net.minecraft.launcher.updater.LowerCaseEnumTypeAdapterFactory;

public class StatusPanelForm
extends SidebarGridForm {
    private static final String SERVER_SESSION = "session.minecraft.net";
    private static final String SERVER_LOGIN = "login.minecraft.net";
    private final Launcher launcher;
    private final JLabel sessionStatus = new JLabel("???");
    private final JLabel loginStatus = new JLabel("???");
    private final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory()).create();

    public StatusPanelForm(Launcher launcher) {
        super("Service Status");
        this.launcher = launcher;
        this.createInterface();
        this.refreshStatuses();
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        this.add(new JLabel("Multiplayer:", 2), constraints, 0, 0, 0, 1, 17);
        this.add(this.sessionStatus, constraints, 1, 0, 1, 1);
        this.add(new JLabel("Login:", 2), constraints, 0, 1, 0, 1, 17);
        this.add(this.loginStatus, constraints, 1, 1, 1, 1);
    }

    public JLabel getSessionStatus() {
        return this.sessionStatus;
    }

    public JLabel getLoginStatus() {
        return this.loginStatus;
    }

    public void refreshStatuses() {
        this.launcher.getVersionManager().getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    TypeToken<List<Map<String, ServerStatus>>> token = new TypeToken<List<Map<String, ServerStatus>>>(){};
                    List statuses = (List)StatusPanelForm.this.gson.fromJson(Http.performGet(new URL("http://status.mojang.com/check"), StatusPanelForm.this.launcher.getProxy()), token.getType());
                    for (Map serverStatusInformation : statuses) {
                        if (serverStatusInformation.containsKey(StatusPanelForm.SERVER_LOGIN)) {
                            StatusPanelForm.this.loginStatus.setText(((ServerStatus)((Object)serverStatusInformation.get(StatusPanelForm.SERVER_LOGIN))).title);
                            continue;
                        }
                        if (!serverStatusInformation.containsKey(StatusPanelForm.SERVER_SESSION)) continue;
                        StatusPanelForm.this.sessionStatus.setText(((ServerStatus)((Object)serverStatusInformation.get(StatusPanelForm.SERVER_SESSION))).title);
                    }
                }
                catch (Exception e) {
                    Launcher.getInstance().println("Couldn't get server status", e);
                }
            }
        });
    }

    public static enum ServerStatus {
        GREEN("Online, no problems detected."),
        YELLOW("May be experiencing issues."),
        RED("Offline, experiencing problems.");

        private final String title;

        private ServerStatus(String title) {
            this.title = title;
        }
    }
}

