/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar.login;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.OldAuthentication;
import net.minecraft.launcher.ui.popups.ErrorMessagePopup;
import net.minecraft.launcher.ui.sidebar.login.BaseLogInForm;
import net.minecraft.launcher.ui.sidebar.login.LoginContainerForm;
import org.sparamoule.launcher.util.WorkingDirectoryChooser;

public class NotLoggedInForm
extends BaseLogInForm {
    private final JTextField usernameField = new JTextField(20);
    private final JTextField passwordField = new JTextField(20);
    private final JButton playButton = new JButton("Play");
    private final JButton registerButton = new JButton("Change Directory");

    public NotLoggedInForm(LoginContainerForm container) {
        super(container, "Log In");
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        this.createInterface();
        this.passwordField.setText(Launcher.configFile.getWorkingDirectoryPath());
        this.usernameField.setText(Launcher.configFile.getLastUsername());
    }

    @Override
    protected void populateGrid(GridBagConstraints constraints) {
        constraints.fill = 2;
        JLabel usernameLabel = new JLabel("Username:", 2);
        usernameLabel.setLabelFor(this.usernameField);
        this.add(usernameLabel, constraints, 0, 0, 0, 1);
        this.add(this.usernameField, constraints, 1, 0, 1, 0);
        JLabel passwordLabel = new JLabel("Directory:", 2);
        passwordLabel.setLabelFor(this.passwordField);
        this.add(passwordLabel, constraints, 0, 1, 0, 1);
        this.add(this.passwordField, constraints, 1, 1, 1, 0);
        this.playButton.addActionListener(this);
        this.registerButton.addActionListener(this);
        this.registerButton.setDefaultCapable(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.registerButton);
        buttonPanel.add(this.playButton);
        this.playButton.setFont(new Font(this.playButton.getFont().getName(), 1, this.playButton.getFont().getSize()));
        this.add(buttonPanel, constraints, 0, 3, 0, 0);
    }

    public JTextField getUsernameField() {
        return this.usernameField;
    }

    public JTextField getPasswordField() {
        return this.passwordField;
    }

    public JButton getPlayButton() {
        return this.playButton;
    }

    public JButton getRegisterButton() {
        return this.registerButton;
    }

    @Override
    public void checkLoginState() {
        boolean canLogIn = true;
        if (this.getLauncher().getGameLauncher().isWorking()) {
            canLogIn = false;
        }
        if (this.getLauncher().getVersionManager().getVersions().size() <= 0) {
            canLogIn = false;
        }
        if (this.getLauncher().getAuthentication().isAuthenticating()) {
            canLogIn = false;
        }
        this.playButton.setEnabled(canLogIn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OldAuthentication authentication = this.getLauncher().getAuthentication();
        if (e.getSource() == this.playButton) {
            OldAuthentication.Response response = authentication.getLastSuccessfulResponse();
            if (response != null) {
                this.getLauncher().getGameLauncher().playGame();
            } else {
                this.tryLogIn(true, true);
                Launcher.configFile.setLastUsername(this.usernameField.getText());
                Launcher.configFile.setWorkingDirectoryPath(this.passwordField.getText());
                Launcher.configFile.save();
            }
        } else {
            WorkingDirectoryChooser wdc = new WorkingDirectoryChooser();
            wdc.open(this.getLauncher().getFrame());
            String workingDir = wdc.getWorkingDirectoryPath();
            Launcher.configFile.setWorkingDirectoryPath(workingDir);
            Launcher.configFile.save();
            this.passwordField.setText(workingDir);
            JOptionPane.showMessageDialog(Launcher.getInstance().getFrame(), "Restart the launcher to apply directory changes", "Directory changes", 2);
        }
    }

    public void tryLogIn(final boolean launchOnSuccess, final boolean verbose) {
        final OldAuthentication authentication = this.getLauncher().getAuthentication();
        authentication.setAuthenticating(true);
        this.getLoginContainer().checkLoginState();
        this.getLauncher().getVersionManager().getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.getInstance().println("Trying to log in...");
                    OldAuthentication.Response response = authentication.login(NotLoggedInForm.this.usernameField.getText(), "");
                    if (response.getErrorMessage() != null) {
                        NotLoggedInForm.this.loginFailed(response.getErrorMessage(), verbose);
                    } else if (response.getSessionId() == null) {
                        NotLoggedInForm.this.loginFailed("Could not log in: SessionID was null?", verbose);
                    } else if (response.getPlayerName() == null) {
                        NotLoggedInForm.this.loginFailed("Could not log in: Name was null?", verbose);
                    } else if (response.getUUID() == null) {
                        NotLoggedInForm.this.loginFailed("Could not log in: UUID was null?", verbose);
                    } else {
                        NotLoggedInForm.this.getLauncher().println("Logged in successfully");
                        NotLoggedInForm.this.getLauncher().getAuthentication().setAuthenticating(false);
                        NotLoggedInForm.this.saveAuthenticationDetails();
                        if (launchOnSuccess) {
                            NotLoggedInForm.this.getLauncher().getGameLauncher().playGame();
                        } else {
                            NotLoggedInForm.this.getLoginContainer().checkLoginState();
                        }
                    }
                }
                catch (Throwable ex) {
                    NotLoggedInForm.this.loginFailed("Could not log in: " + ex.getMessage(), verbose);
                }
            }
        });
    }

    private void saveAuthenticationDetails() {
        OldAuthentication.Response response = this.getLauncher().getAuthentication().getLastSuccessfulResponse();
        if (response == null || response.getUsername() == null) {
            return;
        }
        this.getLauncher().getProfileManager().getSelectedProfile().setAuthentication(new OldAuthentication.StoredDetails(response.getUsername(), null, response.getPlayerName()));
        try {
            this.getLauncher().getProfileManager().saveProfiles();
        }
        catch (IOException e) {
            this.getLauncher().println("Couldn't save authentication details to profile", e);
        }
    }

    private void loginFailed(String error, boolean verbose) {
        Launcher.getInstance().println(error);
        if (verbose) {
            ErrorMessagePopup.show(this.getLauncher().getFrame(), error);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotLoggedInForm.this.getLauncher().getAuthentication().setAuthenticating(false);
                NotLoggedInForm.this.getLoginContainer().checkLoginState();
            }
        });
    }
}

