/*
 * Decompiled with CFR 0.152.
 */
package org.sparamoule.launcher.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigFile {
    private final String path;
    private String lastUsername = "";
    private String workingDirectoryPath = "";

    public ConfigFile() {
        this.path = "./config.properties";
    }

    public boolean load() {
        Properties properties = new Properties();
        File file = new File(this.path);
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException ex) {
                Logger.getLogger(ConfigFile.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.lastUsername = properties.getProperty("username");
            this.workingDirectoryPath = properties.getProperty("workingdirectory");
            return true;
        }
        try {
            file.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        properties.put("username", "");
        properties.put("workingdirectory", "");
        try {
            properties.store(new FileOutputStream(file), "");
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public void save() {
        Properties properties = new Properties();
        properties.put("username", this.lastUsername);
        properties.put("workingdirectory", this.workingDirectoryPath);
        try {
            properties.store(new FileOutputStream(new File(this.path)), "");
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getLastUsername() {
        return this.lastUsername;
    }

    public void setLastUsername(String lastUsername) {
        this.lastUsername = lastUsername;
    }

    public String getWorkingDirectoryPath() {
        return this.workingDirectoryPath;
    }

    public void setWorkingDirectoryPath(String workingDirectoryPath) {
        this.workingDirectoryPath = workingDirectoryPath;
    }
}

