/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.io.File;
import java.util.Date;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.Util;

public class ReleaseJson
implements Release.VersionInfo {
    private long releaseTimestamp = 0L;
    private long timestamp = 0L;
    private String download = "";
    private String launchMethod = "";
    private String launchMethodLink = "";
    private String proxyArgs = "-Dhttp.proxyHost=betacraft.uk";
    private String otherName = "";
    private String protocol = "";
    private int fileVersion = -1;
    protected boolean custom = false;
    private final String version;
    private final File json;
    private final Util.PropertyFile properties;
    private String jsonUrl = null;
    public String sha1 = null;
    public String baseVersion = null;

    public ReleaseJson(String version) {
        this(version, null);
    }

    public ReleaseJson(String version, String url) {
        this.version = version;
        this.json = new File(BC.get() + "versions" + File.separator + "jsons", version + ".info");
        this.properties = new Util.PropertyFile(this.json);
        this.jsonUrl = url == null ? "http://files.betacraft.uk/launcher/assets/jsons/" + this.getVersion() + ".info" : url;
        this.jsonUrl = this.jsonUrl.replace(" ", "%20");
        this.readJson();
    }

    public void readJson() {
        try {
            String file_ver;
            String proxy;
            String releaseDate = this.properties.getProperty("release-date");
            String compileDate = this.properties.getProperty("compile-date");
            try {
                this.releaseTimestamp = Long.parseLong(releaseDate);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.timestamp = Long.parseLong(compileDate);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.download = this.properties.getProperty("url");
            this.launchMethod = this.properties.getProperty("launch-method");
            this.launchMethodLink = this.properties.getProperty("launch-method-link");
            this.proxyArgs = proxy = this.properties.hasProperty("proxy-args") ? this.properties.getProperty("proxy-args") : this.proxyArgs;
            this.otherName = this.properties.getProperty("other-name");
            this.protocol = this.properties.getProperty("protocolVersion");
            this.sha1 = this.properties.getProperty("sha1");
            this.baseVersion = this.properties.getProperty("base-version");
            String custom_flag_str = this.properties.getProperty("custom");
            if (custom_flag_str != null) {
                try {
                    this.custom = Boolean.parseBoolean(custom_flag_str);
                }
                catch (Throwable t) {
                    System.err.println("Version " + this.version + " has an invalid `custom` parameter.");
                }
            }
            if ((file_ver = this.properties.getProperty("file-ver")) != null) {
                try {
                    this.fileVersion = Integer.parseInt(file_ver);
                }
                catch (Throwable t) {
                    System.err.println("Version " + this.version + " has an invalid `file-ver` parameter.");
                    if (!this.properties.hasProperty("file-ver")) {
                        this.fileVersion = 0;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public Date getCompileDate() {
        return new Date(this.timestamp);
    }

    public Date getReleaseDate() {
        return new Date(this.releaseTimestamp);
    }

    public String getOtherName() {
        return this.otherName;
    }

    public String getProxyArgs() {
        return this.proxyArgs;
    }

    public String getLaunchMethod() {
        return this.launchMethod;
    }

    public String getLaunchMethodURL() {
        return this.launchMethodLink;
    }

    public String getEntry(String entryname) {
        return this.properties.getProperty(entryname);
    }

    public void setEntry(String entry, String value) {
        this.properties.setProperty(entry, value);
        this.properties.flushToDisk();
        this.readJson();
    }

    public String getDownloadURL() {
        return this.download;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public File getInfoFile() {
        return this.json;
    }

    public static boolean exists(String name) {
        return new File(BC.get() + "versions/jsons/", name + ".info").exists();
    }

    public DownloadResult downloadJson() {
        return Launcher.download(this.jsonUrl, this.getInfoFile());
    }

    public File getJar() {
        return new File(BC.get() + "versions/", this.version + ".jar");
    }

    public boolean hasJar() {
        File jar = this.getJar();
        return jar.exists() && jar.isFile() && !jar.isDirectory();
    }
}

