/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.auth;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Window;
import uk.betacraft.auth.Authenticator;
import uk.betacraft.auth.Credentials;
import uk.betacraft.auth.jsons.microsoft.CheckTokenRequest;
import uk.betacraft.auth.jsons.microsoft.CheckTokenResponse;
import uk.betacraft.auth.jsons.microsoft.MinecraftAuthRequest;
import uk.betacraft.auth.jsons.microsoft.MinecraftAuthResponse;
import uk.betacraft.auth.jsons.microsoft.MinecraftGameOwnRequest;
import uk.betacraft.auth.jsons.microsoft.MinecraftGameOwnResponse;
import uk.betacraft.auth.jsons.microsoft.MinecraftProfileRequest;
import uk.betacraft.auth.jsons.microsoft.MinecraftProfileResponse;
import uk.betacraft.auth.jsons.microsoft.XBLAuthRequest;
import uk.betacraft.auth.jsons.microsoft.XBLXSTSAuthResponse;
import uk.betacraft.auth.jsons.microsoft.XSTSAuthRequest;

public class MicrosoftAuth
extends Authenticator {
    public static final String CLIENT_ID = "8075fa74-4091-4356-a0b8-a7c118ef121c";
    public Credentials credentials = null;

    public MicrosoftAuth(Credentials c) {
        this.credentials = c;
    }

    private void clearFields() {
        if (this.credentials != null) {
            Launcher.accounts.removeAccount(this.credentials);
        }
        this.credentials = null;
    }

    public boolean authenticate() {
        MinecraftAuthResponse mcres;
        if (this.credentials.refresh_token == null) {
            return false;
        }
        CheckTokenResponse ctres = new CheckTokenRequest(null, this.credentials.refresh_token).perform();
        XBLXSTSAuthResponse xblres = new XBLAuthRequest(ctres.access_token).perform();
        if (xblres == null || xblres.isEmpty()) {
            System.out.println("XBL failed!");
            return false;
        }
        XBLXSTSAuthResponse xstsres = new XSTSAuthRequest(xblres.Token).perform();
        if (xstsres == null || xblres.isEmpty()) {
            System.out.println("XSTS failed!");
            return false;
        }
        if (xstsres.Identity != null) {
            if (xstsres.XErr == 2148916233L) {
                System.out.println("No Xbox account registered");
                MicrosoftAuth.displayError(xstsres, Lang.LOGIN_MICROSOFT_NO_XBOX, Lang.LOGIN_MICROSOFT_ERROR);
                return false;
            }
            if (xstsres.XErr == 2148916238L) {
                System.out.println("PARENTAL CONTROL");
                MicrosoftAuth.displayError(xstsres, Lang.LOGIN_MICROSOFT_PARENT, Lang.LOGIN_MICROSOFT_ERROR);
                return false;
            }
            System.out.println("Unexpected error: " + xstsres.XErr);
            MicrosoftAuth.displayError(xstsres, String.format(Lang.UNEXPECTED_ERROR, xstsres.XErr), Lang.LOGIN_MICROSOFT_ERROR);
        }
        if ((mcres = new MinecraftAuthRequest(xblres.DisplayClaims.xui[0].uhs, xstsres.Token).perform()) == null || mcres.isEmpty()) {
            System.out.println("MinecraftAuth failed!");
            return false;
        }
        MinecraftGameOwnResponse mcgores = new MinecraftGameOwnRequest(mcres.access_token).perform();
        if (mcgores == null || mcgores.isEmpty()) {
            System.out.println("MinecraftOwnership failed!");
            return false;
        }
        if (mcgores.items == null || mcgores.items.length == 0) {
            if (mcgores.error != null) {
                MicrosoftAuth.displayError(mcgores, Lang.LOGIN_MICROSOFT_NO_MINECRAFT, Lang.LOGIN_MICROSOFT_ERROR);
            }
            return false;
        }
        MinecraftProfileResponse mcpres = new MinecraftProfileRequest(mcres.access_token).perform();
        if (mcpres == null || mcpres.isEmpty()) {
            System.out.println("MinecraftProfile failed!");
            return false;
        }
        if (mcpres.error != null) {
            MicrosoftAuth.displayError(mcpres, Lang.LOGIN_MICROSOFT_NO_MINECRAFT, Lang.LOGIN_MICROSOFT_ERROR);
            return false;
        }
        this.clearFields();
        this.credentials = new Credentials();
        this.credentials.expires_at = ctres.expires_in * 1000L + System.currentTimeMillis();
        this.credentials.refresh_token = ctres.refresh_token;
        this.credentials.access_token = mcres.access_token;
        this.credentials.username = mcpres.name;
        this.credentials.local_uuid = mcpres.id;
        this.credentials.account_type = Credentials.AccountType.MICROSOFT;
        Launcher.accounts.addAccount(this.credentials);
        Launcher.accounts.setCurrent(this.getCredentials());
        Launcher.auth = this;
        this.authSuccess();
        System.out.println("USERNAME: " + this.credentials.username);
        System.out.println("ACC_UUID: " + this.credentials.local_uuid);
        return true;
    }

    public boolean invalidate() {
        this.clearFields();
        return true;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public static void displayError(Object error, final String title, final String msg) {
        System.out.println("-Stack of " + error.getClass().getSimpleName() + "-");
        for (Field f : error.getClass().getDeclaredFields()) {
            if (Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                System.out.println(f.getName() + "=" + f.get(error));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(Window.mainWindow, msg, title, 0);
            }
        });
        System.out.println("-----------------");
    }
}

