/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.minecraft.launcher.GameLauncher;
import net.minecraft.launcher.LauncherConstants;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.OldAuthentication;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager;
import net.minecraft.launcher.ui.LauncherPanel;
import net.minecraft.launcher.ui.sidebar.login.NotLoggedInForm;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionManager;
import net.minecraft.launcher.updater.download.DownloadJob;

public class Launcher {
    private static Launcher instance;
    private static final List<String> delayedSysout;
    private final VersionManager versionManager;
    private final JFrame frame;
    private final LauncherPanel launcherPanel;
    private final GameLauncher gameLauncher;
    private final File workingDirectory;
    private final Proxy proxy;
    private final PasswordAuthentication proxyAuth;
    private final String[] additionalArgs;
    private final OldAuthentication authentication;
    private final Integer bootstrapVersion;
    private final ProfileManager profileManager;

    public Launcher(JFrame frame, File workingDirectory, Proxy proxy, PasswordAuthentication proxyAuth, String[] args) {
        this(frame, workingDirectory, proxy, proxyAuth, args, 0);
    }

    public Launcher(JFrame frame, File workingDirectory, Proxy proxy, PasswordAuthentication proxyAuth, String[] args, Integer bootstrapVersion) {
        this.bootstrapVersion = bootstrapVersion;
        instance = this;
        Launcher.setLookAndFeel();
        this.proxy = proxy;
        this.proxyAuth = proxyAuth;
        this.additionalArgs = args;
        this.workingDirectory = workingDirectory;
        this.frame = frame;
        this.gameLauncher = new GameLauncher(this);
        this.profileManager = new ProfileManager(this);
        this.authentication = new OldAuthentication(this, proxy);
        this.versionManager = new VersionManager(new LocalVersionList(workingDirectory), new RemoteVersionList(proxy));
        this.launcherPanel = new LauncherPanel(this);
        this.initializeFrame();
        for (String line : delayedSysout) {
            this.launcherPanel.getTabPanel().getConsole().print(line + "\n");
        }
        if (bootstrapVersion < 2) {
            this.showOutdatedNotice();
            return;
        }
        this.downloadResources();
        this.refreshProfiles();
        this.refreshVersions();
        this.println("Launcher 0.8.2 (Dev) (through bootstrap " + bootstrapVersion + ") started on " + OperatingSystem.getCurrentPlatform().getName() + "...");
        if (!OperatingSystem.getCurrentPlatform().isSupported()) {
            this.println("This operating system is unknown or unsupported, we cannot guarantee that the game will launch.");
        }
        this.println("System.getProperty('os.name') == '" + System.getProperty("os.name") + "'");
        this.println("System.getProperty('os.version') == '" + System.getProperty("os.version") + "'");
        this.println("System.getProperty('os.arch') == '" + System.getProperty("os.arch") + "'");
        this.println("System.getProperty('java.version') == '" + System.getProperty("java.version") + "'");
        this.println("System.getProperty('java.vendor') == '" + System.getProperty("java.vendor") + "'");
    }

    private void showOutdatedNotice() {
        String error = "Sorry, but your launcher is outdated! Please redownload it at http://mojang.com/2013/04/1-5-2-pre-release-and-13w17a-snapshot-oh-my/";
        this.frame.getContentPane().removeAll();
        int result = JOptionPane.showOptionDialog(this.frame, error, "Outdated launcher", 0, 0, null, LauncherConstants.LAUNCHER_OUT_OF_DATE_BUTTONS, LauncherConstants.LAUNCHER_OUT_OF_DATE_BUTTONS[0]);
        if (result == 0) {
            try {
                OperatingSystem.openLink(new URI("http://mojang.com/2013/04/1-5-2-pre-release-and-13w17a-snapshot-oh-my/"));
            }
            catch (URISyntaxException e) {
                this.println("Couldn't open bootstrap download link", e);
            }
        }
        this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
    }

    private static void setLookAndFeel() {
        JFrame frame = new JFrame();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable ignored) {
            try {
                Launcher.getInstance().println("Your java failed to provide normal look and feel, trying the old fallback now");
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Throwable t) {
                Launcher.getInstance().println("Unexpected exception setting look and feel");
                t.printStackTrace();
            }
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("test"));
        frame.add(panel);
        try {
            frame.pack();
        }
        catch (Throwable t) {
            Launcher.getInstance().println("Custom (broken) theme detected, falling back onto x-platform theme");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Throwable ex) {
                Launcher.getInstance().println("Unexpected exception setting look and feel", ex);
            }
        }
        frame.dispose();
    }

    private void downloadResources() {
        final DownloadJob job = new DownloadJob("Resources", true, this.gameLauncher);
        this.gameLauncher.addJob(job);
        this.versionManager.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.this.versionManager.downloadResources(job);
                    job.startDownloading(Launcher.this.versionManager.getExecutorService());
                }
                catch (IOException e) {
                    Launcher.getInstance().println("Unexpected exception queueing resource downloads", e);
                }
            }
        });
    }

    public void refreshVersions() {
        this.versionManager.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.this.versionManager.refreshVersions();
                }
                catch (Throwable e) {
                    Launcher.getInstance().println("Unexpected exception refreshing version list", e);
                }
            }
        });
    }

    public void refreshProfiles() {
        this.versionManager.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Launcher.this.profileManager.loadProfiles()) {
                        OldAuthentication.StoredDetails result = Launcher.this.authentication.getStoredDetails();
                        if (result != null) {
                            result = new OldAuthentication.StoredDetails(result.getUsername(), null, result.getDisplayName());
                            Profile profile = Launcher.this.profileManager.getSelectedProfile();
                            profile.setAuthentication(result);
                            Launcher.this.profileManager.saveProfiles();
                            Launcher.this.println("Initialized default profile with old lastlogin details");
                        } else {
                            Launcher.this.println("Created default profile with no authentication details");
                        }
                    } else {
                        Launcher.this.println("Loaded " + Launcher.this.profileManager.getProfiles().size() + " profile(s); selected '" + Launcher.this.profileManager.getSelectedProfile().getName() + "'");
                    }
                }
                catch (Throwable e) {
                    Launcher.getInstance().println("Unexpected exception refreshing profile list", e);
                }
                try {
                    String username;
                    Profile profile = Launcher.this.profileManager.getSelectedProfile();
                    if (profile.getAuthentication() != null && (username = profile.getAuthentication().getUsername()) != null && username.length() > 0) {
                        NotLoggedInForm form = Launcher.this.launcherPanel.getSidebar().getLoginForm().getNotLoggedInForm();
                        form.getUsernameField().setText(username);
                        String password = Launcher.this.authentication.guessPasswordFromSillyOldFormat(username);
                        if (password != null && password.length() > 0) {
                            Launcher.this.println("Going to log in with legacy stored username & password...");
                            form.getPasswordField().setText(password);
                            form.tryLogIn(false, false);
                        }
                    }
                }
                catch (Throwable e) {
                    Launcher.getInstance().println("Unexpected exception logging in with stored credentials", e);
                }
            }
        });
    }

    protected void initializeFrame() {
        this.frame.getContentPane().removeAll();
        this.frame.setTitle("Minecraft Launcher 0.8.2 (Dev)");
        this.frame.setPreferredSize(new Dimension(925, 525));
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Launcher.this.frame.setVisible(false);
                Launcher.this.frame.dispose();
                Launcher.this.versionManager.getExecutorService().shutdown();
            }
        });
        try {
            InputStream in = Launcher.class.getResourceAsStream("/favicon.png");
            if (in != null) {
                this.frame.setIconImage(ImageIO.read(in));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.frame.add(this.launcherPanel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public LauncherPanel getLauncherPanel() {
        return this.launcherPanel;
    }

    public GameLauncher getGameLauncher() {
        return this.gameLauncher;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public PasswordAuthentication getProxyAuth() {
        return this.proxyAuth;
    }

    public String[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    public OldAuthentication getAuthentication() {
        return this.authentication;
    }

    public void println(String line) {
        System.out.println(line);
        if (this.launcherPanel == null) {
            delayedSysout.add(line);
        } else {
            this.launcherPanel.getTabPanel().getConsole().print(line + "\n");
        }
    }

    public void println(String line, Throwable throwable) {
        this.println(line);
        this.println(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Throwable throwable) {
        StringWriter writer = null;
        PrintWriter printWriter = null;
        String result = throwable.toString();
        try {
            writer = new StringWriter();
            printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            result = writer.toString();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.println(result);
    }

    public int getBootstrapVersion() {
        return this.bootstrapVersion;
    }

    public static Launcher getInstance() {
        return instance;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    static {
        delayedSysout = new ArrayList<String>();
    }
}

