/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.OldAuthentication;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessRunnable;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.ui.tabs.CrashReportTab;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.updater.download.DownloadJob;
import net.minecraft.launcher.updater.download.DownloadListener;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library;
import org.apache.commons.io.FileUtils;

public class GameLauncher
implements JavaProcessRunnable,
DownloadListener {
    private final Object lock = new Object();
    private final Launcher launcher;
    private final List<DownloadJob> jobs = new ArrayList<DownloadJob>();
    private CompleteVersion version;
    private boolean isWorking = false;
    private File nativeDir = null;

    public GameLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorking(boolean working) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nativeDir != null) {
                Launcher.getInstance().println("Deleting " + this.nativeDir);
                if (!this.nativeDir.isDirectory() || FileUtils.deleteQuietly(this.nativeDir)) {
                    this.nativeDir = null;
                } else {
                    Launcher.getInstance().println("Couldn't delete " + this.nativeDir + " - scheduling for deletion upon exit");
                    try {
                        FileUtils.forceDeleteOnExit(this.nativeDir);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.isWorking = working;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameLauncher.this.launcher.getLauncherPanel().getSidebar().getLoginForm().checkLoginState();
                }
            });
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playGame() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isWorking) {
                this.launcher.println("Tried to play game but game is already starting!");
                return;
            }
            this.setWorking(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameLauncher.this.launcher.getLauncherPanel().getTabPanel().showConsole();
            }
        });
        this.launcher.println("Getting syncinfo for selected version");
        VersionSyncInfo syncInfo = (VersionSyncInfo)this.launcher.getLauncherPanel().getSidebar().getVersionSelection().getVersionList().getSelectedItem();
        if (syncInfo == null) {
            Launcher.getInstance().println("Tried to launch a version without a version being selected...");
            this.setWorking(false);
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.launcher.println("Queueing library & version downloads");
            try {
                this.version = this.launcher.getVersionManager().getLatestCompleteVersion(syncInfo);
            }
            catch (IOException e) {
                Launcher.getInstance().println("Couldn't get complete version info for " + syncInfo.getLatestVersion(), e);
                this.setWorking(false);
                return;
            }
            if (!syncInfo.isInstalled()) {
                try {
                    VersionList localVersionList = this.launcher.getVersionManager().getLocalVersionList();
                    if (localVersionList instanceof LocalVersionList) {
                        ((LocalVersionList)localVersionList).saveVersion(this.version);
                        Launcher.getInstance().println("Installed " + syncInfo.getLatestVersion());
                    }
                }
                catch (IOException e) {
                    Launcher.getInstance().println("Couldn't save version info to install " + syncInfo.getLatestVersion(), e);
                    this.setWorking(false);
                    return;
                }
            }
            try {
                DownloadJob job = new DownloadJob("Version & Libraries", false, this);
                this.addJob(job);
                this.launcher.getVersionManager().downloadVersion(syncInfo, job);
                job.startDownloading(this.launcher.getVersionManager().getExecutorService());
            }
            catch (IOException e) {
                Launcher.getInstance().println("Couldn't get version info for " + syncInfo.getLatestVersion(), e);
                this.setWorking(false);
                return;
            }
        }
    }

    protected void launchGame() {
        List<String> profileArgs;
        this.launcher.println("Launching game");
        Profile selectedProfile = this.launcher.getProfileManager().getSelectedProfile();
        this.nativeDir = new File(this.launcher.getWorkingDirectory(), "versions/" + this.version.getId() + "/" + this.version.getId() + "-natives-" + System.nanoTime());
        if (!this.nativeDir.isDirectory()) {
            this.nativeDir.mkdirs();
        }
        this.launcher.println("Unpacking natives to " + this.nativeDir);
        try {
            this.unpackNatives(this.version, this.nativeDir);
        }
        catch (IOException e) {
            Launcher.getInstance().println("Couldn't unpack natives!", e);
            return;
        }
        File gameDirectory = selectedProfile.getGameDir() == null ? this.launcher.getWorkingDirectory() : selectedProfile.getGameDir();
        Launcher.getInstance().println("Launching in " + gameDirectory);
        JavaProcessLauncher processLauncher = new JavaProcessLauncher(selectedProfile.getJavaPath(), new String[0]);
        processLauncher.directory(gameDirectory);
        if (OperatingSystem.getCurrentPlatform().equals((Object)OperatingSystem.OSX)) {
            processLauncher.addCommands("-Xdock:icon=assets/icons/minecraft.icns", "-Xdock:name=Minecraft");
        }
        if ((profileArgs = selectedProfile.getJvmArgs()) != null) {
            processLauncher.addCommands(profileArgs.toArray(new String[profileArgs.size()]));
        } else {
            processLauncher.addCommands("-Xmx1G");
        }
        processLauncher.addCommands("-Djava.library.path=" + this.nativeDir.getAbsolutePath());
        processLauncher.addCommands("-cp", this.constructClassPath(this.version));
        processLauncher.addCommands(this.version.getMainClass());
        OldAuthentication.Response loginResponse = this.launcher.getAuthentication().getLastSuccessfulResponse();
        if (this.version.getProcessArguments() != null && loginResponse != null && loginResponse.getPlayerName() != null && loginResponse.getSessionId() != null && loginResponse.getUUID() != null) {
            processLauncher.addCommands(this.version.getProcessArguments().formatAuthResponse(loginResponse).split(" "));
        }
        Proxy proxy = this.launcher.getProxy();
        PasswordAuthentication proxyAuth = this.launcher.getProxyAuth();
        if (!proxy.equals(Proxy.NO_PROXY)) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            processLauncher.addCommands("--proxyHost", address.getHostName());
            processLauncher.addCommands("--proxyPort", Integer.toString(address.getPort()));
            if (proxyAuth != null) {
                processLauncher.addCommands("--proxyUser", proxyAuth.getUserName());
                processLauncher.addCommands("--proxyPass", new String(proxyAuth.getPassword()));
            }
        }
        processLauncher.addCommands("--workDir", gameDirectory.getAbsolutePath());
        processLauncher.addCommands(this.launcher.getAdditionalArgs());
        try {
            String command = JavaProcessLauncher.buildCommands(processLauncher.getFullCommands());
            Launcher.getInstance().println("Running: " + command);
            JavaProcess process = processLauncher.start();
            process.safeSetExitRunnable(this);
            Launcher.getInstance().println("---- YOU CAN CLOSE THIS LAUNCHER IF THE GAME STARTED OK ----");
            Launcher.getInstance().println("---- YOU CAN CLOSE THIS LAUNCHER IF THE GAME STARTED OK ----");
            Launcher.getInstance().println("---- YOU CAN CLOSE THIS LAUNCHER IF THE GAME STARTED OK ----");
            Launcher.getInstance().println("---- (We'll do this automatically later ;D) ----");
        }
        catch (IOException e) {
            Launcher.getInstance().println("Couldn't launch game", e);
            this.setWorking(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackNatives(CompleteVersion version, File targetDir) throws IOException {
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        Collection<Library> libraries = version.getRelevantLibraries(os);
        for (Library library : libraries) {
            Map<OperatingSystem, String> nativesPerOs = library.getNatives();
            if (nativesPerOs == null || nativesPerOs.get((Object)os) == null) continue;
            File file = new File(this.launcher.getWorkingDirectory(), library.getArtifactPath(nativesPerOs.get((Object)os)));
            ZipFile zip = new ZipFile(file);
            ExtractRules extractRules = library.getExtractRules();
            try {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (extractRules != null && !extractRules.shouldExtract(entry.getName())) continue;
                    File targetFile = new File(targetDir, entry.getName());
                    if (targetFile.getParentFile() != null) {
                        targetFile.getParentFile().mkdirs();
                    }
                    if (entry.isDirectory()) continue;
                    BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] buffer = new byte[2048];
                    FileOutputStream outputStream = new FileOutputStream(targetFile);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                    try {
                        int length;
                        while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                            bufferedOutputStream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        Downloadable.closeSilently(bufferedOutputStream);
                        Downloadable.closeSilently(outputStream);
                        Downloadable.closeSilently(inputStream);
                    }
                }
            }
            finally {
                zip.close();
            }
        }
    }

    private String constructClassPath(CompleteVersion version) {
        StringBuilder result = new StringBuilder();
        Collection<File> classPath = version.getClassPath(OperatingSystem.getCurrentPlatform(), this.launcher.getWorkingDirectory());
        String separator = System.getProperty("path.separator");
        for (File file : classPath) {
            if (!file.isFile()) {
                throw new RuntimeException("Classpath file not found: " + file);
            }
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(file.getAbsolutePath());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onJavaProcessEnded(JavaProcess process) {
        block7: {
            String errorText;
            block9: {
                int exitCode;
                block8: {
                    exitCode = process.getExitCode();
                    if (exitCode != 0) break block8;
                    Launcher.getInstance().println("Game ended with no troubles detected (exit code " + exitCode + ")");
                    break block7;
                }
                Launcher.getInstance().println("Game ended with bad state (exit code " + exitCode + ")");
                errorText = null;
                String[] sysOut = process.getSysOutLines().getItems();
                for (int i = sysOut.length - 1; i >= 0; --i) {
                    String line = sysOut[i];
                    String crashIdentifier = "#@!@#";
                    int pos = line.lastIndexOf(crashIdentifier);
                    if (pos < 0 || pos >= line.length() - crashIdentifier.length() - 1) continue;
                    errorText = line.substring(pos + crashIdentifier.length()).trim();
                    break;
                }
                if (errorText == null) break block7;
                File file = new File(errorText);
                if (!file.isFile()) break block9;
                Launcher.getInstance().println("Crash report detected, opening: " + errorText);
                FileInputStream inputStream = null;
                try {
                    String line;
                    inputStream = new FileInputStream(file);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuilder result = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (result.length() > 0) {
                            result.append("\n");
                        }
                        result.append(line);
                    }
                    reader.close();
                    this.launcher.getLauncherPanel().getTabPanel().setCrashReport(new CrashReportTab(file, result.toString()));
                }
                catch (IOException e) {
                    try {
                        Launcher.getInstance().println("Couldn't open crash report", e);
                    }
                    catch (Throwable throwable) {
                        Downloadable.closeSilently(inputStream);
                        throw throwable;
                    }
                    Downloadable.closeSilently(inputStream);
                    break block7;
                }
                Downloadable.closeSilently(inputStream);
                break block7;
            }
            Launcher.getInstance().println("Crash report detected, but unknown format: " + errorText);
        }
        this.setWorking(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadJobFinished(DownloadJob job) {
        this.updateProgressBar();
        Object object = this.lock;
        synchronized (object) {
            if (job.getFailures() > 0) {
                this.launcher.println("Job '" + job.getName() + "' finished with " + job.getFailures() + " failure(s)!");
                this.setWorking(false);
            } else {
                this.launcher.println("Job '" + job.getName() + "' finished successfully");
                if (this.isWorking() && !this.hasRemainingJobs()) {
                    try {
                        this.launchGame();
                    }
                    catch (Throwable ex) {
                        Launcher.getInstance().println("Fatal error launching game. Report this to http://mojang.atlassian.net please!", ex);
                    }
                }
            }
        }
    }

    @Override
    public void onDownloadJobProgressChanged(DownloadJob job) {
        this.updateProgressBar();
    }

    protected void updateProgressBar() {
        final float progress = this.getProgress();
        final boolean hasTasks = this.hasRemainingJobs();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameLauncher.this.launcher.getLauncherPanel().getProgressBar().setVisible(hasTasks);
                GameLauncher.this.launcher.getLauncherPanel().getProgressBar().setValue((int)(progress * 100.0f));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getProgress() {
        Object object = this.lock;
        synchronized (object) {
            float max = this.jobs.size();
            float result = 0.0f;
            for (DownloadJob job : this.jobs) {
                result += job.getProgress();
            }
            return result / max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemainingJobs() {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadJob job : this.jobs) {
                if (job.isComplete()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(DownloadJob job) {
        Object object = this.lock;
        synchronized (object) {
            this.jobs.add(job);
        }
    }
}

